% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim-models.R
\name{sim_4_emo}
\alias{sim_4_emo}
\title{Simulate a 4-emotion model}
\usage{
sim_4_emo(time = 200, init = c(1.36, 1.36, 4.89, 4.89), sd = 1)
}
\arguments{
\item{time}{The number of time steps to simulate.}

\item{init}{A vector of initial values for the four variables. Default is c(1.36, 1.36, 4.89, 4.89), which is one of the stable states of the model.}

\item{sd}{The standard deviation of the noise.}
}
\value{
A matrix with the simulated data.
}
\description{
This function simulates a 4-emotion model which is nonlinear, bistable, discrete, and (almost) centered to zero. Adapted from the model described by van de Leemput et al. (2014).
}
\references{
van de Leemput, I. A., Wichers, M., Cramer, A. O., Borsboom, D., Tuerlinckx, F., Kuppens, P., ... & Scheffer, M. (2014). Critical slowing down as early warning for the onset and termination of depression. Proceedings of the National Academy of Sciences, 111(1), 87-92.
}
\seealso{
\code{\link[=true_model_4_emo]{true_model_4_emo()}}, \code{\link[=compare_4_emo]{compare_4_emo()}}, \code{\link[=quadVAR]{quadVAR()}}
}
