% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_qc_mapping.R
\name{read_qc_mapping}
\alias{read_qc_mapping}
\title{Read Quality Control mapping file}
\usage{
read_qc_mapping(path)
}
\arguments{
\item{path}{excel file path to be read. Each tab should contain
3 tabs with the names missing, inconsistencies and range. Each tab
will correspond to one QC mapping table.

QC mapping \code{excel} file should contain 3 tabs:
\itemize{
\item missing: columns should be named as "qc_type",
"variable" and `type".
\item inconsistencies: columns should be named as "qc_type",
"variable1", "type1", "relation", "variable2" and "type2".
\item range: columns should be named as "qc_type",
"variable", "type", "lower_value", "upper_value" and "categories".
}

The columns specified above should contain specific values:
\itemize{
\item qc_type: "missing", "duplicated", "inconsistent_values" and "range"
\item variable, variable1, variable2: variable name that is included in data.
\item type, type1, type2: "numeric", text", "categorical", "date"
\item relation: expected relation between variable1 and variable2 which can be
"greater_than", "greater_than_or_equal", "lower_than", "lower_than_or_equal" or "equal".
\item lower_value, upper_value: expected numeric values representing ranges
\item categories: expected variable categories
}}
}
\value{
A list containing all the QC mapping tables
}
\description{
\code{read_qc_mapping} reads an \code{.xlsx} file that contains
the QC mapping.
}
