% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qc_function.R
\name{test_range}
\alias{test_range}
\title{Test the range of a variable on a dataset}
\usage{
test_range(
  data,
  variable,
  type,
  categories = NULL,
  lower_value = NULL,
  upper_value = NULL
)
}
\arguments{
\item{data}{data to be tested.}

\item{variable}{The variable to be tested.}

\item{type}{String such as 'categorical', 'date' or 'numeric'}

\item{categories}{Only to be filled if \code{type} is 'categorical'. String of categories.}

\item{lower_value}{Only to be filled if \code{type} is 'numeric' or 'date'. Can be numeric or string.}

\item{upper_value}{Only to be filled if \code{type} is 'numeric' or 'date'. Can be numeric or string.}
}
\value{
A data frame containing all the findings regarding the applied test.
}
\description{
Test the range of a variable on a dataset
}
\examples{
test_range(als_data, 'onset', c('bulbar','respiratory', 'spinal'), type = 'categorical')
test_range(als_data, 'age_at_baseline', lower_value = 20, upper_value = 100, 
type = 'numeric')
test_range(als_data, 'age_at_onset', lower_value = 20, upper_value = 100,
type = 'numeric')
test_range(als_data, 'baseline_date', lower_value = '2000-01-01', upper_value = '2022-01-01', 
type = 'date')
test_range(als_data, 'death_date', lower_value = '2000-01-01', upper_value = '2022-01-01',
 type = 'date')
}
