% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textplot_xray.R
\name{textplot_xray}
\alias{textplot_xray}
\title{Plot the dispersion of key word(s)}
\usage{
textplot_xray(..., scale = c("absolute", "relative"), sort = FALSE)
}
\arguments{
\item{...}{any number of \link[quanteda:kwic]{kwic} class objects}

\item{scale}{\code{"relative"} or \code{"absolute"}: whether to scale the token index
axis by absolute position of the token in the document or by relative
position. Defaults are \code{"absolute"} for single document and \code{"relative"}
for multiple documents.}

\item{sort}{whether to sort the rows of a multiple document plot by document
name}
}
\value{
a \pkg{ggplot2} object
}
\description{
Plots a dispersion or "x-ray" plot of selected word pattern(s) across one or
more texts. The format of the plot depends on the number of
\link[quanteda:kwic]{kwic} class objects passed: if there is only one document,
keywords are plotted one below the other. If there are multiple documents the
documents are plotted one below the other, with keywords shown side-by-side.
Given that this returns a \pkg{ggplot2} object, you can modify the plot by
adding \pkg{ggplot2} layers (see example).
}
\section{Known Issues}{

These are known issues on which we are working to solve in future versions:
\itemize{
\item \code{textplot_xray()} will not display the patterns correctly when
these are multi-token sequences.
\item For dictionaries with keys that have overlapping value matches to tokens in
the text, only the first match will be used in the plot.  The way around this
is to produce one kwic per dictionary key, and send them as a list to
\code{textplot_xray}.
}
}

\examples{
library("quanteda")
toks <- data_corpus_inaugural |>
  corpus_subset(Year > 1970) |>
  tokens()
# compare multiple documents
textplot_xray(kwic(toks, pattern = "american"))
textplot_xray(kwic(toks, pattern = "american"), scale = "absolute")

# compare multiple terms across multiple documents
textplot_xray(kwic(toks, pattern = "america*"),
              kwic(toks, pattern = "people"))

\dontrun{
# how to modify the ggplot with different options
library("ggplot2")
tplot <- textplot_xray(kwic(toks, pattern = "american"),
                       kwic(toks, pattern = "people"))
tplot + aes(color = keyword) + scale_color_manual(values = c('red', 'blue'))

# adjust the names of the document names
docnames(toks) <- apply(docvars(toks, c("Year", "President")), 1, paste, collapse = ", ")
textplot_xray(kwic(toks, pattern = "america*"),
              kwic(toks, pattern = "people"))
}
}
\keyword{textplot}
