% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crossq.max.partial.R
\name{crossq.max.partial}
\alias{crossq.max.partial}
\title{Partial Corss-Quantilogram upto a given lag order}
\usage{
crossq.max.partial(DATA, vecA, Kmax)
}
\arguments{
\item{DATA}{An input matrix}

\item{vecA}{A vector of probability values at which sample quantiles are estimated}

\item{Kmax}{The maximum lag order (integer)}
}
\value{
A vector of cross-quantilogram and a vector of partial cross-quantilograms
}
\description{
The partial cross-quantilograms from 1 to a given lag order.
}
\details{
This function calculates the partial cross-quantilograms up to the lag order
users specify.
}
\examples{
## data source 
data("sys.risk") 

## data with 3 variables 
D = sys.risk[,c("Market", "JPM", "VIX")]

## probablity levels for the 3 variables 
vecA = c(0.1, 0.1, 0.1)

## partial cross-quantilogram with lags from 1 to 5
crossq.max.partial(D, vecA, 5)

}
\references{
Han, H., Linton, O., Oka, T., and Whang, Y. J. (2016).
"The cross-quantilogram: Measuring quantile dependence and testing directional predictability between time series." \emph{Journal of Econometrics}, 193(1), 251-270.
}
\author{
Heejoon Han, Oliver Linton, Tatsushi Oka and Yoon-Jae Whang
}
