% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table-helper.R
\name{tbl_qmd_elements}
\alias{tbl_qmd_elements}
\alias{tbl_qmd_span}
\alias{tbl_qmd_div}
\alias{tbl_qmd_span_base64}
\alias{tbl_qmd_div_base64}
\alias{tbl_qmd_span_raw}
\alias{tbl_qmd_div_raw}
\title{Create Quarto Markdown HTML Elements for Tables}
\usage{
tbl_qmd_span(content, display = NULL, use_base64 = TRUE)

tbl_qmd_div(content, display = NULL, use_base64 = TRUE)

tbl_qmd_span_base64(content, display = NULL)

tbl_qmd_div_base64(content, display = NULL)

tbl_qmd_span_raw(content, display = NULL)

tbl_qmd_div_raw(content, display = NULL)
}
\arguments{
\item{content}{Character string of content to wrap. This can include Markdown,
LaTeX math, and Quarto shortcodes.}

\item{display}{Optional display text (if different from content). Useful for
fallback text when Quarto processing is not available or for better
accessibility.}

\item{use_base64}{Logical, whether to base64 encode the content (recommended
for complex content with special characters or when content includes quotes)}
}
\value{
Character string containing the HTML element with appropriate data-qmd attributes
}
\description{
Functions to wrap content in HTML spans or divs with data-qmd attributes for
Quarto processing within HTML tables. These functions are specifically designed
for use with HTML table packages like kableExtra, gt, or DT where you need
Quarto to process markdown content within table cells.
}
\details{
These functions create HTML elements with \code{data-qmd} or \code{data-qmd-base64}
attributes that Quarto processes during document rendering. The base64
encoding is recommended for content with special characters, quotes, or
complex formatting.

Available functions:
\itemize{
\item \code{tbl_qmd_span()} and \code{tbl_qmd_div()} are the main functions with encoding options
\item \code{tbl_qmd_span_base64()} and \code{tbl_qmd_div_base64()} explicitly use base64 encoding
\item \code{tbl_qmd_span_raw()} and \code{tbl_qmd_div_raw()} explicitly use raw encoding
}

This feature requires Quarto version 1.3 or higher with HTML format outputs.
For more information, see \url{https://quarto.org/docs/authoring/tables.html#html-tables}.
}
\examples{
# Basic span usage in table cells
tbl_qmd_span("**bold text**")
tbl_qmd_span("$\\\\alpha + \\\\beta$", display = "Greek formula")

# Basic div usage in table cells
tbl_qmd_div("## Section Title\n\nContent here")
tbl_qmd_div("{{< video https://example.com >}}", display = "[Video content]")

# Explicit encoding choices
tbl_qmd_span_base64("Complex $\\\\LaTeX$ content")
tbl_qmd_span_raw("Simple text")

# Use with different HTML table packages
\dontrun{
# With kableExtra
library(kableExtra)
df <- data.frame(
  math = c(tbl_qmd_span("$x^2$"), tbl_qmd_span("$\\\\sum_{i=1}^n x_i$")),
  text = c(tbl_qmd_span("**Important**", "bold"), tbl_qmd_span("`code`", "code"))
)
kbl(df, format = "html", escape = FALSE) |> kable_styling()
}
}
