% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operators.R, R/config.R
\docType{data}
\name{query-operator}
\alias{query-operator}
\alias{queryOperator}
\alias{setQueryOperators}
\alias{listQueryOperators}
\alias{default_operators}
\title{Register new or list existing query operators}
\format{
An object of class \code{list} of length 20.
}
\usage{
queryOperator(method)

setQueryOperators(..., .queryBuilderConfig = queryBuilderConfig)

listQueryOperators(.queryBuilderConfig = queryBuilderConfig, print = TRUE)

default_operators
}
\arguments{
\item{method}{R function the operator should be transformed to when parsing result to R expression.
The function should take at most two parameters. The first one (obligatory) is variable vector,
the second one additional parameters interpreted by operator.
Could be negated with exclamation mark e.g. \code{queryOperator(!startsWith)} which will be interpreted as
the negation of the associated expression.}

\item{...}{Name-value pairs defining operator name and method respectively.
Should be defined with usage of \code{queryOperator} function.}

\item{.queryBuilderConfig}{R6 class object storing query configuration. See \link{queryBuilderConfigClass}.}

\item{print}{Should the list of operators be printed into console?}
}
\value{
A single `quote` storing the provided method.
}
\description{
Operator are functions of maximum two arguments.
The first argument is interpreted as a field (e.g. column name),
the second one as a filtering value interpreted by operator accordingly.
Some operators, such as 'is_empty' (that compares field values to empty string) don't require any value provided.
}
\details{
Operators are stored as \link{quote}s, that are further interpreted while converting the query to
filtering expression.

\itemize{
  \item{\code{queryOperator}: defines a custom operator that can be used in generated query.}
  \item{\code{setQueryOperators}:
    is used to register the defined operators in the default or custom \link{queryBuilderConfigClass} object.
  }
  \item{\code{listQueryOperators}: allows to list available operators for the specific column type.}
  \item{\code{default_operators}: an object storing default definitions for operators.}
}
}
\examples{

listQueryOperators()

in_closed_range <- function(x, range) {
  x >= range[1] & x <= range[2]
}

setQueryOperators(
  "within" = queryOperator(in_closed_range),
  "not_within" = queryOperator(!in_closed_range)
)
query <- queryGroup(
  condition = "AND",
  queryRule("am", "equal", 1),
  queryRule("qsec", "within", c(10, 15)),
  queryRule("disp", "not_within", c(10, 15))
)
queryToExpr(query)

}
\keyword{datasets}
