% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quest_functions.R
\name{pomps}
\alias{pomps}
\title{Recode Numeric Data to Percentage of Maximum Possible (POMP) Units}
\usage{
pomps(
  data,
  vrb.nm,
  mini,
  maxi,
  relative = FALSE,
  unit = 1,
  suffix = paste0("_p", unit)
)
}
\arguments{
\item{data}{data.frame of data.}

\item{vrb.nm}{character vector of colnames from \code{data} specifying the
variables.}

\item{mini}{numeric vector of length 1 specifying the minimum numeric value
possible. Note, this is assumed to be the same for each variable.}

\item{maxi}{numeric vector of length 1 specifying the maximum numeric value
possible. Note, this is assumed to be the same for each variable.}

\item{relative}{logical vector of length 1 specifying whether relative POMP
scores (rather than absolute POMP scores) should be created. If TRUE, then
the \code{mini} and \code{maxi} arguments are ignored. See details for the
distinction between absolute and relative POMP scores.}

\item{unit}{numeric vector of length 1 specifying how many percentage points
is desired for the units. Traditionally, POMP scores use \code{unit} = 1
(default) such that one unit is one percentage point. However, another
option is to use \code{unit} = 100 such that one unit is all 100 percentage
points (i.e., proportion of maximum possible). This argument also gives the
flexibility of specifying units in between 1 and 100 percentage points. For
example, \code{unit} = 50 would mean that one unit represents going from
low (i.e., 25th percentile) to high (i.e., 75th percentile) on the
variable.}

\item{suffix}{character vector of length 1 specifying the string to add to
the end of the column names in the return object.}
}
\value{
data.frame of variables recoded to percentage of maximum possible
  (pomp) with units specified by \code{unit} and names specified by
  \code{paste0(vrb.nm, suffix)}.
}
\description{
\code{pomps} recodes numeric data to percentage of maximum possible (POMP)
units. This can be useful when data is measured with arbitrary units (e.g.,
Likert scale).
}
\details{
There are two common approaches to POMP scores: 1) absolute POMP units where
the minimum and maximum are the smallest/largest values possible from the
measurement instrument (e.g., 1 to 7 on a Likert scale) and 2) relative POMP
units where the minimum and maximum are the smallest/largest values observed
in the data (e.g., 1.3 to 6.8 on a Likert scale). Both will be correlated
perfectly with the original units as they are each linear transformations.
}
\examples{
vrb_nm <- names(psych::bfi)[grepl(pattern = "A", x = names(psych::bfi))]
pomps(data = psych::bfi, vrb.nm = vrb_nm, min = 1, max = 6) # absolute POMP units
pomps(data = psych::bfi, vrb.nm = vrb_nm, relative = TRUE) # relative POMP units
pomps(data = psych::bfi, vrb.nm = vrb_nm, min = 1, max = 6, unit = 100) # unit = 100
pomps(data = psych::bfi, vrb.nm = vrb_nm, min = 1, max = 6, unit = 50) # unit = 50
pomps(data = psych::bfi, vrb.nm = vrb_nm, min = 1, max = 6, suffix = "_pomp")
}
\seealso{
\code{\link{pomp}}
}
