% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaClasses.R
\docType{class}
\name{BFBayesFactorConstraint-class}
\alias{BFBayesFactorConstraint-class}
\title{S4 class for representing Bayes factor model comparisons and the Bayes factor
  for user-defined constraints}
\description{
\code{BFBayesFactorConstraint} is a S4 class that represents the Bayes factors
  of multiple model comparisons and the Bayes factor of all individual effects
  adhering to user-defined constraints. Furthermore, it also has slots
  defined for representing the design matrices of the constraints model, and
  for representing prior and posterior estimates.
}
\section{Slots}{

\describe{
\item{\code{generalTestObj}}{an object of class \code{BFBayesFactor} representing the
model comparisons. All S4 methods as defined in
\code{\link[BayesFactor]{BFBayesFactor-class}} can be used.}

\item{\code{constraints}}{an object of class \code{\link{BFConstraint-class}}.}

\item{\code{individualEffects}}{a list containing a named vector for each level of the
effect defined in the constraints. Effects are comprised of the common
effect plus the individual deviation from it.}

\item{\code{posteriorMean}}{a named numeric giving the mean of the common effect.}

\item{\code{posteriorSD}}{a named numeric giving the standard deviation of
individual effects.}

\item{\code{totalThetas}}{a list containing a \code{data.frame} for each level of the
effect defined in the constraints. Rows are sampling iterations and columns
comprised of individual estimates plus the common effect estimates.}

\item{\code{mcmcFull}}{an object of class \code{BFmcmc}, containing the MCMC samples
from the posterior.}

\item{\code{designIndeces}}{a list giving the column indeces of the mcmcFull that
were used to calculate the estimates of interest.}

\item{\code{observedEffects}}{a list containing a named vector for each level of the
effect defined in the constraints. Values are the mean observed effect for
each individual.}
}}

