% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geometric_mean_sd.R
\name{gmean}
\alias{gmean}
\alias{gvar}
\alias{gsd}
\title{Geometric Mean, Variance, and Standard Deviation}
\usage{
gmean(x, na_rm = FALSE)

gvar(x, na_rm = FALSE)

gsd(x, na_rm = FALSE)
}
\arguments{
\item{x}{a numeric vector}

\item{na_rm}{a logical value indicating whether \code{NA} values should be
stripped before the computation proceeds.}
}
\value{
a numeric value
}
\description{
Return the geometric mean, variance, and standard deviation,
}
\examples{

gmean(mtcars$mpg)
identical(gmean(mtcars$mpg), exp(mean(log(mtcars$mpg))))

gvar(mtcars$mpg)
identical(gvar(mtcars$mpg),
          exp(var(log(mtcars$mpg)) * (nrow(mtcars) - 1) / nrow(mtcars)))

gsd(mtcars$mpg)
identical(gsd(mtcars$mpg),
          exp(sqrt( var(log(mtcars$mpg)) * (nrow(mtcars) - 1) / nrow(mtcars))))

#############################################################################
set.seed(42)
x <- runif(14, min = 4, max = 70)

# geometric mean - four equivalent ways to get the same result
prod(x) ^ (1 / length(x))
exp(mean(log(x)))
1.2 ^ mean(log(x, base = 1.2))
gmean(x)

# geometric variance
gvar(x)

# geometric sd
exp(sd(log(x)))                                     ## This is wrong (incorrect sample size)
exp(sqrt((length(x) - 1) / length(x)) * sd(log(x))) ## Correct calculation
gsd(x)

# Missing data will result in and NA being returned
x[c(2, 4, 7)] <- NA
gmean(x)
gmean(x, na_rm = TRUE)
gvar(x, na_rm = TRUE)
gsd(x, na_rm = TRUE)

}
\seealso{
\code{\link{gmean_sd}} for easy formatting of the geometric mean and
standard deviation.  \code{vignette("summary-statistics", package =
"qwraps2")}.
}
