% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmean_sd.R
\name{gmean_sd}
\alias{gmean_sd}
\title{Geometric Mean and Standard deviation}
\usage{
gmean_sd(
  x,
  digits = getOption("qwraps2_frmt_digits", 2),
  na_rm = FALSE,
  show_n = "ifNA",
  denote_sd = "pm",
  markup = getOption("qwraps2_markup", "latex"),
  ...
)
}
\arguments{
\item{x}{a numeric vector}

\item{digits}{digits to the right of the decimal point to return in the
percentage estimate.}

\item{na_rm}{if true, omit NA values}

\item{show_n}{defaults to \dQuote{ifNA}.  Other options are \dQuote{always} or
\dQuote{never}.}

\item{denote_sd}{a character string set to either "pm" or "paren" for reporting 'mean
\eqn{\pm} sd' or 'mean (sd)'}

\item{markup}{character string with value \dQuote{latex} or \dQuote{markdown}}

\item{...}{pass through}
}
\value{
a character vector of the formatted values
}
\description{
A function for calculating and formatting geometric means and
standard deviations.
}
\details{
Given a numeric vector, \code{gmean_sd} will return a character string with
the geometric mean and standard deviation.  Formatting of the output will be
extended in future versions.
}
\examples{

gmean_sd(mtcars$mpg, markup = "latex")
gmean_sd(mtcars$mpg, markup = "markdown")

}
\seealso{
\code{\link{mean_sd}}, \code{\link{gmean}}, \code{\link{gsd}}
}
