package ch.idsia.blip.api.learn.solver;


import ch.idsia.blip.api.TheTest;
import ch.idsia.blip.api.learn.solver.win.WinAsobsImprSolverApi;
import ch.idsia.blip.core.learn.solver.WinAsobsPertSolver;
import ch.idsia.blip.core.learn.solver.WinAsobsSolver;
import ch.idsia.blip.core.learn.solver.src.winasobs.WinAsobsSearcher;
import ch.idsia.blip.core.learn.solver.src.winasobs.WinAsobsSearcherPerturbation;
import ch.idsia.blip.core.utils.other.IncorrectCallException;
import ch.idsia.blip.core.utils.data.ArrayUtils;
import org.junit.Test;

import java.io.IOException;
import java.util.Arrays;

import static ch.idsia.blip.core.utils.RandomStuff.*;
import static ch.idsia.blip.core.utils.data.ArrayUtils.cloneArray;


public class WinAsobsChecker extends TheTest {
    @Test
    public void testTest() throws Exception {
        WinAsobsSolver si = new WinAsobsSolver();

        si.max_windows = 1;
        WinAsobsSearcher s = new WinAsobsSearcher(si);

        si.sc = getScoreReader(basePath + "/winasobs/net30.d.jkl");
        si.n_var = si.sc.length;
        si.prepare();

        s.init(si.sc, 1);
        // vars = new int[]{18, 17, 2, 27, 75, 38, 80, 105, 84, 67, 42, 7, 63, 102, 44, 94, 79, 65, 45, 55, 1, 81, 29, 58, 101, 92, 108, 76, 25, 50, 3, 109, 19, 13, 28, 57, 39, 4, 34, 82, 6, 100, 73, 107, 51, 10, 49, 64, 97, 98, 53, 37, 83, 69, 61, 30, 74, 85, 72, 43, 15, 22, 62, 47, 8, 96, 90, 0, 70, 24, 71, 26, 87, 48, 54, 103, 66, 11, 78, 16, 104, 106, 89, 23, 77, 95, 91, 20, 88, 41, 31, 36, 32, 52, 110, 59, 33, 68, 56, 46, 12, 21, 40, 14, 86, 60, 9, 5, 99, 93, 35};
        // s.vars = new int[] {35,93,99,5,9,60,86,14,40,21,12,46,56,68,33,59,110,52,32,36,31,41,88,20,91,95,77,23,89,106,104,16,78,11,66,103,54,48,87,26,71,24,70,0,90,96,8,47,62,22,15,43,72,85,74,30,61,69,83,37,53,98,97,64,49,10,51,107,73,100,6,82,34,4,39,57,28,13,19,109,3,50,25,76,108,92,101,58,29,81,1,55,45,65,79,94,44,102,63,7,42,67,84,105,80,38,75,27,2,17,18};
        s.vars = new int[] {7, 26, 17, 28, 3, 22, 29, 19, 14, 1, 12, 20, 11, 15, 21, 24, 0, 23, 16, 4, 9, 25, 13, 6, 10, 18, 27, 2, 5, 8};
        s.initStr();
        p(Arrays.toString(s.vars));
        p(s.sk);
        p(s.checkSk());

        if (!si.testAcyclic(s.str))
            throw new Exception("ACYCLIC!");

        if (Math.abs(s.sk - -1380795.418198) > 0.0001) {
            throw new Exception(f("Init different score! %.2f", s.sk));
        }

        long start = System.currentTimeMillis();
        int[] pivots = new int[] {
            26, 1, 28, 18, 12, 10, 24, 6, 24, 6, 29, 8,
            15, 9, 15, 25, 6, 11, 18, 20, 26, 2, 16, 15, 0, 1, 6, 7, 2, 0, 7, 1};
        long[] scores = new long[] {
            1378384495, 1378382495, 1367713429,
            1367713217, 1365667704, 1357781068, 1344154595, 1343971459,
            1335972877, 1333690681, 1331232609, 1331230109, 1329456057,
            1329132489, 1329121087, 1324492511, 1319202341, 1319186898,
            1316889296, 1311745495, 1302616894, 1301540913, 1301409342,
            1301134264, 1301132912, 1301131816, 1300645837, 1300345837,
            1295881947, 1295814701, 1295702793, 1295692041};

        ;

        for (int i = 0; i < pivots.length; i++) {
            int pivot = pivots[i];

            s.greedy(pivot);
            p(s.vars);
            // p(Arrays.toString(str));
            pf("%d | %.2f \n", pivot, s.sk);
            if (Math.abs(s.sk - (-scores[i] / 1000.0)) > 0.01) {
                throw new Exception(
                        f("At %d different score! %.2f", i, s.sk));
            }
        }

        s.greedy(29);

        pf("elapsed time: %.2f \n",
                (System.currentTimeMillis() - start) / 1000.0);
        pf("score: %.2f \n", s.sk);
    }

    @Test
    public void testTest2() throws IncorrectCallException, IOException {

        int w = 1;

        WinAsobsSolver si = new WinAsobsSolver();

        si.max_exec_time = 999;
        si.max_windows = w;
        WinAsobsSearcher s = new WinAsobsSearcher(si);

        s.init(getScoreReader(basePath + "/winasobs/net30.d.jkl"), 1);

        long start = System.currentTimeMillis();

        s.vars = new int[] {
            7, 26, 17, 28, 3, 22, 29, 19, 14, 1, 12, 20, 11, 15,
            21, 24, 0, 23, 16, 4, 9, 25, 13, 6, 10, 18, 27, 2, 5, 8};
        s.initStr();
        p(Arrays.toString(s.vars));
        p(s.sk);

        s.winasobs();

        pf("elapsed time: %.2f \n",
                (System.currentTimeMillis() - start) / 1000.0);
        pf("score: %.2f \n", s.sk);

        p("ciao");
    }

    @Test
    public void testLink() throws IncorrectCallException, IOException {
        String s = "/home/loskana/Desktop/winasobs/";

        WinAsobsImprSolverApi.main(
                new String[] {
            "", // "-j", set + "pigs-5000.jkl",
            "-j", s + "accidents.test.jkl", "-r", s + "p", "-win", "3", "-pa",
            "10", "-pb", "10", "-v", "1", "-b", "1", "-t", "30000"
        });
    }

    @Test
    public void test() throws IncorrectCallException, IOException {
        WinAsobsPertSolver si = new WinAsobsPertSolver();

        si.max_windows = 1;
        si.max_exec_time = 999;
        si.sc = getScoreReader(
                "/home/loskana/Desktop/winasobs/exp/data/ad.test.jkl", 1);
        si.max_windows = 1;
        si.n_var = si.sc.length;
        si.prepare();

        int[] gg = new int[] {
            188, 346, 672, 495, 447, 1229, 827, 1357, 498,
            386, 1397, 395, 551, 654, 692, 1340, 512, 1409, 1502, 116, 1036, 877,
            416, 596, 84, 649, 599, 912, 570, 790, 545, 189, 87, 471, 0, 1023,
            1192, 1133, 170, 226, 660, 691, 1318, 1424, 635, 667, 540, 18, 615,
            1233, 321, 1160, 104, 1400, 748, 212, 694, 442, 1178, 1510, 1541,
            1553, 987, 622, 1007, 829, 700, 159, 1426, 1536, 354, 1382, 713, 184,
            61, 959, 1287, 506, 1313, 426, 675, 1184, 609, 1474, 404, 334, 422,
            1264, 232, 721, 1367, 1390, 275, 1227, 183, 454, 1335, 980, 235, 465,
            114, 261, 1119, 962, 164, 1303, 348, 1049, 284, 619, 68, 1345, 1374,
            456, 1015, 1371, 397, 380, 1040, 82, 522, 1042, 1244, 1254, 204,
            1337, 924, 1185, 658, 624, 530, 1459, 1458, 1025, 480, 1043, 1019,
            1406, 1117, 476, 1069, 437, 1389, 726, 311, 1530, 1432, 1346, 388,
            652, 1540, 754, 13, 1385, 1179, 231, 1170, 548, 363, 262, 881, 1218,
            359, 1201, 1232, 1437, 451, 398, 815, 661, 919, 616, 614, 144, 254,
            1336, 576, 869, 1282, 750, 1544, 1353, 1125, 26, 762, 1011, 1452,
            246, 342, 597, 1147, 1429, 312, 746, 172, 946, 1462, 71, 1498, 339,
            1516, 1507, 1026, 874, 1286, 138, 725, 526, 266, 742, 405, 821, 767,
            1163, 508, 957, 178, 573, 1138, 302, 1101, 120, 417, 527, 749, 665,
            324, 501, 1375, 1422, 1465, 201, 1481, 1497, 187, 153, 541, 1205,
            525, 977, 574, 598, 1066, 716, 1425, 1511, 1491, 1071, 133, 1263,
            1058, 143, 314, 1078, 1008, 1067, 849, 1366, 528, 107, 462, 642,
            1081, 136, 1012, 345, 866, 2, 1334, 954, 256, 25, 875, 293, 1223,
            944, 1219, 794, 401, 1514, 445, 537, 666, 1108, 428, 394, 819, 482,
            890, 1529, 90, 1350, 1552, 1551, 1393, 1359, 1221, 1087, 1543, 646,
            1301, 1394, 1384, 30, 766, 562, 110, 383, 563, 154, 60, 237, 264,
            809, 455, 1509, 1074, 842, 1348, 826, 910, 559, 1364, 1433, 1500,
            1305, 1030, 200, 4, 198, 458, 1442, 1431, 1413, 1226, 1070, 1262,
            1173, 103, 402, 197, 1054, 1161, 653, 210, 283, 549, 1162, 124, 1420,
            1419, 205, 298, 1260, 273, 1115, 249, 1203, 538, 1126, 241, 119, 588,
            91, 276, 1298, 771, 425, 294, 36, 1472, 12, 684, 1072, 326, 1109,
            937, 761, 579, 1128, 1234, 645, 617, 1428, 989, 460, 112, 818, 483,
            65, 934, 1398, 517, 244, 64, 1280, 1214, 1194, 1325, 259, 1470, 315,
            629, 773, 1242, 1172, 797, 1537, 1204, 662, 303, 586, 196, 429, 930,
            612, 277, 921, 1267, 974, 1171, 1113, 287, 229, 396, 1448, 895, 532,
            1522, 1324, 83, 657, 214, 1060, 1283, 1236, 370, 639, 1235, 1360,
            257, 1014, 994, 626, 1062, 54, 998, 1092, 115, 630, 1051, 137, 1295,
            225, 1157, 374, 132, 861, 1483, 355, 157, 1534, 1312, 1505, 824, 621,
            23, 759, 419, 349, 1271, 915, 611, 613, 459, 1329, 557, 697, 1526,
            867, 221, 427, 1061, 1198, 900, 408, 1327, 308, 193, 993, 939, 42,
            329, 271, 1308, 1016, 1028, 415, 863, 1228, 485, 1423, 35, 689, 595,
            833, 1089, 855, 805, 1402, 1527, 704, 718, 369, 648, 703, 299, 1098,
            663, 288, 799, 1037, 291, 1102, 605, 702, 578, 807, 628, 781, 457,
            1444, 1209, 222, 1281, 1369, 1440, 670, 593, 215, 41, 531, 304, 1445,
            192, 242, 736, 260, 76, 1079, 1053, 1002, 952, 389, 414, 680, 768,
            1455, 1259, 1333, 1539, 139, 1488, 841, 1153, 208, 1435, 1475, 1176,
            1370, 477, 885, 956, 469, 730, 500, 452, 1168, 106, 307, 1347, 935,
            1, 523, 1421, 28, 281, 487, 450, 318, 958, 834, 1190, 804, 978, 1294,
            582, 1032, 1174, 8, 336, 55, 1105, 864, 1372, 306, 1059, 467, 338,
            1320, 814, 981, 825, 310, 59, 413, 659, 899, 1159, 282, 1114, 1310,
            160, 1471, 710, 891, 1404, 727, 878, 1533, 1068, 269, 378, 1387, 510,
            1434, 1096, 604, 1391, 72, 1546, 1453, 203, 1188, 601, 1124, 1427,
            560, 180, 448, 1021, 647, 1354, 1104, 1342, 853, 686, 735, 347, 760,
            942, 341, 121, 360, 717, 1116, 131, 1212, 19, 399, 553, 93, 1261,
            709, 406, 905, 975, 1156, 1018, 1193, 493, 1144, 690, 9, 1535, 1276,
            1135, 478, 1155, 142, 810, 1469, 897, 1538, 831, 1073, 625, 774,
            1297, 973, 698, 1112, 186, 524, 1255, 687, 1064, 940, 1418, 390,
            1460, 1237, 1379, 1207, 365, 776, 362, 688, 1525, 873, 1216, 423,
            158, 461, 488, 832, 333, 1351, 379, 758, 546, 1029, 943, 1166, 757,
            865, 1017, 393, 278, 637, 1291, 953, 472, 1180, 706, 420, 247, 1356,
            1332, 463, 1248, 728, 305, 161, 835, 1395, 769, 765, 1545, 17, 577,
            507, 117, 243, 1449, 1136, 638, 1454, 263, 1257, 89, 1314, 1031,
            1480, 140, 1265, 38, 892, 88, 39, 955, 499, 1080, 1403, 1127, 1202,
            1035, 1477, 432, 656, 1468, 375, 1252, 149, 618, 358, 300, 858, 868,
            1187, 1341, 871, 66, 1151, 1241, 385, 313, 862, 798, 1439, 411, 430,
            854, 732, 502, 913, 1381, 555, 146, 85, 238, 1300, 568, 382, 236,
            876, 47, 1331, 491, 52, 376, 322, 1006, 870, 1249, 1407, 985, 707,
            971, 1317, 211, 701, 938, 220, 340, 745, 837, 806, 894, 1149, 719,
            267, 1131, 353, 176, 1057, 289, 693, 991, 1063, 961, 988, 901, 640,
            357, 63, 3, 1484, 1088, 529, 585, 439, 808, 45, 926, 1376, 606, 453,
            872, 1482, 1106, 218, 285, 1473, 1319, 504, 995, 1250, 1278, 166,
            150, 715, 591, 803, 268, 466, 105, 179, 1363, 712, 920, 772, 561,
            245, 747, 520, 109, 1492, 1304, 603, 521, 43, 741, 74, 1129, 923,
            323, 802, 1293, 1164, 1148, 632, 763, 1143, 859, 209, 258, 409, 780,
            830, 970, 1315, 685, 1277, 516, 344, 156, 823, 608, 851, 1001, 155,
            145, 290, 391, 162, 1499, 1519, 936, 947, 724, 793, 909, 224, 1034,
            1368, 46, 48, 337, 941, 1410, 69, 248, 678, 882, 503, 234, 102, 996,
            400, 792, 1309, 165, 631, 1220, 436, 141, 951, 332, 1196, 801, 535,
            1377, 1121, 1289, 643, 252, 1352, 714, 29, 976, 1182, 496, 126, 636,
            755, 1085, 1122, 223, 1246, 587, 641, 1521, 1323, 1165, 1518, 838,
            207, 373, 696, 564, 964, 1326, 1355, 1322, 813, 233, 1213, 7, 301,
            1132, 1022, 782, 543, 828, 228, 896, 552, 1520, 886, 519, 431, 194,
            1009, 1045, 722, 381, 364, 21, 350, 167, 44, 108, 550, 1217, 412,
            850, 123, 410, 169, 206, 1041, 515, 795, 883, 1137, 928, 600, 118,
            152, 173, 58, 317, 1146, 1110, 361, 1501, 1508, 1118, 879, 424, 1134,
            812, 822, 434, 79, 572, 796, 816, 1461, 1215, 836, 99, 418, 1046,
            421, 848, 1446, 475, 1284, 1494, 486, 536, 51, 932, 903, 1000, 239,
            1296, 1231, 97, 384, 1169, 16, 734, 1004, 633, 1139, 435, 534, 857,
            1199, 1075, 1517, 377, 960, 320, 922, 566, 494, 217, 20, 1251, 1208,
            80, 880, 127, 1130, 567, 15, 1195, 1177, 175, 1380, 1238, 1349, 489,
            296, 1082, 343, 1365, 623, 856, 1450, 286, 1103, 122, 309, 32, 682,
            789, 195, 468, 775, 982, 1554, 906, 1239, 387, 539, 1405, 182, 800,
            191, 1490, 1489, 950, 479, 1417, 440, 1378, 1503, 607, 1411, 1396,
            844, 10, 1548, 130, 1140, 1181, 581, 1150, 1438, 366, 177, 1358,
            1388, 683, 720, 331, 86, 931, 1486, 1495, 1240, 1523, 738, 1141,
            1415, 1258, 1175, 40, 1050, 81, 444, 216, 783, 929, 1003, 101, 509,
            1086, 372, 1145, 1416, 752, 1094, 129, 1485, 583, 34, 492, 94, 274,
            674, 744, 779, 328, 265, 213, 1272, 148, 681, 1024, 1430, 295, 733,
            927, 174, 1279, 1044, 668, 446, 513, 933, 230, 554, 1531, 1464, 979,
            699, 634, 335, 1027, 367, 673, 740, 610, 371, 1547, 1302, 968, 986,
            569, 764, 11, 739, 584, 1123, 202, 565, 1478, 1479, 592, 98, 785,
            677, 514, 839, 907, 918, 787, 356, 1243, 1100, 1107, 1512, 1225,
            1532, 860, 1189, 1290, 135, 887, 1097, 22, 620, 77, 1463, 1316, 983,
            544, 185, 1412, 925, 92, 1306, 1457, 1550, 251, 470, 1048, 1383, 227,
            966, 368, 840, 945, 904, 1285, 1496, 1476, 1515, 676, 1361, 1167,
            972, 664, 1222, 181, 1099, 1555, 1451, 219, 1047, 644, 650, 279,
            1441, 57, 1392, 1436, 737, 1224, 1456, 1292, 1183, 669, 27, 1493,
            1269, 1447, 1256, 729, 852, 1065, 884, 1362, 297, 847, 708, 1158,
            1191, 811, 671, 1055, 327, 1245, 990, 272, 1288, 1020, 1399, 1270,
            969, 24, 255, 31, 270, 547, 6, 199, 679, 590, 50, 70, 113, 1010,
            1467, 1524, 1013, 575, 134, 1197, 965, 1052, 1211, 151, 533, 594,
            125, 481, 518, 898, 473, 1142, 1343, 916, 100, 147, 474, 62, 1247,
            705, 484, 786, 1307, 53, 351, 655, 788, 1401, 997, 731, 542, 627,
            171, 37, 67, 292, 917, 556, 253, 992, 743, 984, 497, 817, 1120, 319,
            723, 571, 280, 751, 1186, 558, 190, 1268, 843, 73, 711, 1152, 845,
            352, 1230, 1338, 778, 403, 911, 250, 1311, 1200, 96, 5, 1111, 1266,
            433, 602, 777, 695, 1154, 1210, 511, 1084, 948, 770, 1408, 1090,
            1386, 1274, 1273, 1005, 846, 888, 784, 999, 490, 95, 1542, 49, 168,
            949, 589, 443, 1330, 1504, 1275, 756, 56, 1549, 1076, 1038, 580, 75,
            14, 441, 128, 464, 1077, 438, 1339, 1039, 967, 914, 1487, 889, 1206,
            33, 753, 1056, 902, 505, 240, 893, 1506, 1083, 1321, 316, 1443, 407,
            78, 449, 330, 1373, 1091, 163, 1513, 963, 1344, 1253, 1095, 325, 651,
            1299, 392, 1414, 820, 791, 1466, 1528, 111, 1093, 1328, 1033, 908};

        ArrayUtils.reverse(gg);

        WinAsobsSearcherPerturbation s = new WinAsobsSearcherPerturbation(si);

        s.init(si.sc);
        si.sc = s.m_scores;

        pf("score: %.2f \n", s.sk);

        double t = 0;

        for (int i = 0; i < 100; i++) {
            long start = System.currentTimeMillis();

            s.vars = s.smp.sample();
            s.initStr();
            s.winasobs();
            double req = (System.currentTimeMillis() - start) / 1000.0;

            p(req);
            t += req;
        }

        pf("Mean winasobs time: %.3f \n", t / 100);
    }

    @Test
    public void test2() throws IncorrectCallException, IOException {
        int w = 1;
        WinAsobsPertSolver si = new WinAsobsPertSolver();

        si.verbose = 1;
        si.max_exec_time = 999;
        si.sc = getScoreReader("/home/loskana/Desktop/pigs-5000.jkl", 1);
        si.max_windows = w;
        si.n_var = si.sc.length;
        si.prepare();

        int[] gg = new int[] {
            53, 346, 109, 12, 287, 273, 91, 114, 436, 311,
            343, 219, 3, 99, 92, 387, 6, 103, 105, 341, 157, 321, 275, 27, 5, 0,
            10, 30, 1, 369, 55, 113, 151, 326, 187, 21, 2, 31, 9, 163, 90, 60,
            75, 78, 220, 226, 223, 94, 261, 14, 435, 152, 420, 119, 184, 57, 298,
            290, 149, 201, 345, 45, 69, 156, 120, 215, 322, 282, 432, 306, 147,
            162, 72, 65, 169, 353, 88, 438, 106, 197, 422, 126, 350, 324, 7, 440,
            171, 167, 222, 4, 178, 206, 129, 380, 404, 203, 208, 84, 146, 38,
            199, 64, 59, 372, 112, 247, 240, 26, 334, 97, 131, 296, 137, 335, 77,
            302, 245, 293, 213, 212, 128, 289, 221, 243, 272, 179, 44, 259, 165,
            125, 274, 82, 70, 85, 416, 154, 121, 100, 202, 347, 164, 263, 87,
            429, 17, 299, 32, 42, 76, 414, 58, 63, 364, 286, 412, 268, 11, 18,
            160, 270, 111, 238, 294, 331, 150, 102, 430, 141, 224, 130, 313, 124,
            33, 24, 29, 330, 34, 257, 342, 325, 254, 349, 366, 95, 246, 292, 148,
            161, 127, 424, 122, 419, 188, 239, 271, 433, 304, 15, 196, 183, 236,
            314, 116, 390, 337, 204, 434, 235, 74, 291, 110, 385, 348, 421, 22,
            253, 43, 228, 234, 332, 155, 283, 362, 397, 359, 281, 260, 168, 371,
            425, 145, 143, 225, 218, 279, 115, 181, 265, 278, 66, 280, 237, 398,
            374, 189, 376, 305, 323, 170, 172, 175, 142, 368, 200, 104, 241, 205,
            20, 379, 394, 210, 399, 389, 413, 361, 83, 39, 25, 333, 357, 73, 354,
            439, 46, 193, 67, 255, 285, 93, 192, 40, 195, 61, 351, 101, 191, 89,
            174, 229, 340, 315, 288, 319, 227, 407, 232, 144, 252, 194, 180, 363,
            86, 386, 327, 320, 47, 48, 264, 360, 344, 49, 355, 284, 233, 312, 23,
            37, 35, 382, 352, 81, 231, 309, 266, 79, 182, 383, 140, 339, 190,
            249, 392, 317, 62, 56, 177, 28, 303, 248, 365, 256, 8, 123, 329, 415,
            211, 209, 19, 198, 217, 417, 377, 54, 336, 250, 358, 307, 186, 300,
            370, 51, 214, 134, 68, 71, 405, 406, 411, 301, 338, 135, 136, 297,
            16, 207, 318, 431, 244, 277, 13, 437, 138, 269, 267, 427, 375, 41,
            185, 98, 316, 402, 401, 423, 391, 118, 378, 393, 403, 173, 216, 133,
            356, 258, 328, 395, 117, 310, 262, 230, 295, 426, 139, 107, 108, 396,
            381, 242, 308, 251, 276, 418, 158, 159, 153, 50, 388, 410, 409, 132,
            166, 96, 176, 384, 80, 428, 373, 408, 367, 400, 36, 52};
        // ILS got -793211
        // ArrayUtils.reverse(gg);

        WinAsobsSearcherPerturbation s = new WinAsobsSearcherPerturbation(si);

        s.init(si.sc);
        si.sc = s.m_scores;

        long start = System.currentTimeMillis();

        s.vars = cloneArray(gg);
        s.perturb();
        pf("score: %.2f \n", s.sk);

        s.vars = gg;
        s.asobsOpt();
        s.perturb();
        pf("score: %.2f \n", s.sk);

    }

    @Test
    public void test3() throws IncorrectCallException, IOException {
        int w = 3;
        WinAsobsSolver si = new WinAsobsSolver();

        si.verbose = 1;
        si.max_exec_time = 999;
        si.sc = getScoreReader(
                "/home/loskana/Desktop/winasobs/exp/data/book.test.jkl", 1);
        si.max_windows = w;
        si.n_var = si.sc.length;
        si.prepare();
        si.max_windows = w;

        int[] gg = new int[] {
            117, 227, 54, 379, 370, 277, 433, 464, 93, 100,
            341, 476, 134, 365, 68, 228, 259, 89, 351, 416, 427, 318, 357, 467,
            342, 203, 51, 452, 24, 255, 330, 96, 271, 444, 459, 56, 13, 169, 87,
            196, 248, 324, 346, 349, 126, 279, 485, 4, 138, 429, 65, 244, 143,
            120, 85, 151, 86, 128, 315, 162, 426, 419, 182, 139, 234, 384, 210,
            88, 238, 313, 188, 52, 98, 114, 359, 392, 276, 133, 247, 403, 495,
            62, 6, 375, 189, 309, 272, 360, 437, 186, 353, 1, 344, 456, 332, 312,
            157, 29, 280, 135, 212, 448, 488, 176, 463, 221, 399, 165, 32, 400,
            338, 141, 150, 380, 217, 172, 366, 439, 445, 198, 59, 363, 496, 314,
            383, 289, 101, 322, 393, 326, 35, 431, 197, 283, 480, 417, 16, 423,
            493, 369, 199, 185, 19, 180, 50, 361, 233, 368, 443, 490, 218, 474,
            160, 23, 294, 311, 253, 193, 263, 177, 129, 60, 264, 440, 167, 281,
            124, 136, 260, 381, 308, 148, 348, 69, 131, 5, 115, 319, 422, 286,
            22, 321, 262, 374, 53, 28, 130, 478, 339, 483, 230, 137, 266, 225,
            103, 55, 457, 461, 187, 430, 302, 340, 245, 200, 66, 333, 317, 7,
            209, 411, 226, 104, 497, 9, 232, 269, 84, 78, 36, 413, 166, 183, 164,
            58, 231, 446, 378, 267, 21, 414, 481, 168, 335, 3, 278, 354, 409,
            303, 408, 394, 215, 388, 159, 291, 201, 102, 175, 107, 252, 468, 256,
            405, 153, 301, 337, 239, 224, 390, 347, 122, 492, 223, 202, 94, 155,
            327, 336, 0, 420, 106, 484, 91, 306, 487, 305, 79, 144, 250, 436, 49,
            343, 27, 47, 382, 83, 290, 179, 325, 454, 72, 161, 44, 258, 257, 33,
            296, 119, 489, 192, 428, 38, 156, 410, 450, 111, 213, 371, 116, 243,
            471, 8, 63, 334, 242, 494, 123, 385, 80, 300, 402, 42, 154, 466, 191,
            469, 110, 345, 229, 70, 43, 146, 432, 438, 206, 297, 304, 105, 310,
            26, 25, 352, 449, 125, 112, 31, 184, 99, 292, 92, 358, 270, 142, 236,
            77, 362, 386, 241, 389, 235, 113, 453, 145, 473, 479, 275, 298, 285,
            240, 251, 331, 477, 109, 30, 498, 274, 367, 475, 39, 108, 415, 37,
            355, 152, 11, 307, 377, 395, 397, 273, 45, 407, 81, 295, 412, 171,
            376, 486, 74, 132, 246, 219, 173, 268, 41, 391, 458, 434, 17, 282,
            460, 73, 170, 76, 455, 95, 451, 97, 178, 470, 2, 401, 57, 373, 127,
            158, 491, 424, 222, 75, 121, 316, 396, 482, 435, 174, 237, 442, 299,
            499, 149, 181, 71, 195, 190, 40, 323, 48, 46, 293, 387, 287, 356,
            328, 265, 364, 261, 421, 254, 462, 329, 15, 12, 10, 147, 67, 90, 284,
            82, 204, 441, 20, 194, 372, 118, 465, 418, 249, 406, 350, 140, 472,
            320, 447, 64, 205, 214, 288, 208, 425, 220, 34, 216, 207, 18, 404,
            61, 163, 398, 211, 14};
        // ILS got -63709210693 in 1 minute
        // ArrayUtils.reverse(gg);

        WinAsobsSearcher s = new WinAsobsSearcher(si);

        s.init(si.sc);
        si.sc = s.m_scores;

        long start = System.currentTimeMillis();

        s.vars = gg;
        s.asobsOpt();
        s.winasobs();
        pf("score: %.2f \n", s.sk);

    }

}
