% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_species.R
\name{prepare_species}
\alias{prepare_species}
\title{Check the species data for consistency}
\usage{
prepare_species(species)
}
\arguments{
\item{species}{table containing the information about species level data. Each row corresponds to one species/cohort.
\itemize{
\item species: species or cohort id/name. It must be consistent with species names in \code{thinning}, \code{parameters} and \code{sizeDist} tables.
\item planted: year and month indicating when species was planted. Provided in form of year-month. E.g. "2000-01".
\item fertility: soil fertility for a given species. Range from 0 to 1.
\item stems_n: number of trees per ha.
\item biom_stem: stem biomass for a given species (Mg/ha).
\item biom_root: root biomass for a given species (Mg/ha).
\item biom_foliage: initial foliage biomass (Mg/ha). If this is a leafless period, provide the spring foliage biomass.
}}
}
\value{
a data.frame with one row
}
\description{
Prepares the species table, by checking whether the input information is consistent.
}
\details{
This function check the species table for \code{\link{run_3PG}}.
}
\examples{
# check species data
prepare_species( species = d_species)
}
\seealso{
\code{\link{run_3PG}}, \code{\link{prepare_input}}, \code{\link{prepare_parameters}}, \code{\link{prepare_sizeDist}}, \code{\link{prepare_thinning}}, \code{\link{prepare_site}}
}
