% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3JSobjects.R
\name{triangle3js}
\alias{triangle3js}
\title{Add a triangle to a data3js object}
\usage{
triangle3js(data3js, vertices, col = "black", highlight, ...)
}
\arguments{
\item{data3js}{The data3js object}

\item{vertices}{An nx3 matrix of triangle vertices}

\item{col}{Single color for the triangles or vector of vertex colors}

\item{highlight}{highlight attributes (see \code{highlight3js()})}

\item{...}{Additional attributes to pass to \code{material3js()}}
}
\value{
Returns an updated data3js object
}
\description{
Add a triangle to a data3js object
}
\examples{
# Draw some random triangles
M <- matrix(
  data = rnorm(36),
  ncol = 3,
  nrow = 12
)

p <- plot3js(
  xlim = range(M[,1]),
  ylim = range(M[,2]),
  zlim = range(M[,3]),
  label_axes = FALSE
)

p <- triangle3js(
  p,
  vertices = M,
  col = rainbow(nrow(M))
)

r3js(p, zoom = 2)

}
\seealso{
Other plot components: 
\code{\link{arrows3js}()},
\code{\link{axis3js}()},
\code{\link{box3js}()},
\code{\link{grid3js}()},
\code{\link{legend3js}()},
\code{\link{light3js}()},
\code{\link{lines3js}()},
\code{\link{mtext3js}()},
\code{\link{points3js}()},
\code{\link{segments3js}()},
\code{\link{shape3js}()},
\code{\link{sphere3js}()},
\code{\link{surface3js}()},
\code{\link{text3js}()}
}
\concept{plot components}
