% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_gradients.R
\name{fit_gradients}
\alias{fit_gradients}
\title{Fit Gradient Models to Data}
\usage{
fit_gradients(data, C = 1)
}
\arguments{
\item{data}{A dataframe containing the data, with columns "x" representing distances and
"Y" representing the corresponding measurements or counts.}

\item{C}{A constant to be used in the modified power model. Defaults to 1.}
}
\value{
A list containing:
\item{data}{The input data, which will include an additional column 'mod_x'.}
\item{results_table}{A table of the model parameters and R-squared values.}
\item{plot_exponential}{Diagnostic plot for the exponential model.}
\item{plot_power}{Diagnostic plot for the power model.}
\item{plot_modified_power}{Diagnostic plot for the modified power model.}
\item{plot_exponential_original}{Plot of the original data with the exponential model fit.}
\item{plot_power_original}{Plot of the original data with the power model fit.}
\item{plot_modified_power_original}{Plot of the original data with the modified power model fit.}
}
\description{
This function fits three gradient models (exponential, power, and modified power) to given data.
It then ranks the models based on their R-squared values and returns diagnostic plots for each model.
}
\examples{
x <- c(0.8, 1.6, 2.4, 3.2, 4, 7.2, 12, 15.2, 21.6, 28.8)
Y <- c(184.9, 113.3, 113.3, 64.1, 25, 8, 4.3, 2.5, 1, 0.8)
grad1 <- data.frame(x = x, Y = Y)
library(ggplot2)
mg <- fit_gradients(grad1, C = 0.4)
mg$plot_power_original +
  labs(title = "", x = "Distance from focus (m)", y = "Count of lesions")

}
\seealso{
Other Spatial analysis: 
\code{\link{AFSD}()},
\code{\link{BPL}()},
\code{\link{count_subareas}()},
\code{\link{count_subareas_random}()},
\code{\link{join_count}()},
\code{\link{oruns_test}()},
\code{\link{oruns_test_boustrophedon}()},
\code{\link{oruns_test_byrowcol}()},
\code{\link{plot_AFSD}()}
}
\concept{Spatial analysis}
