% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/5.2_Taguchi_designs_Classes.R
\name{taguchiFactor}
\alias{taguchiFactor}
\title{taguchiFactor}
\description{
An R6 class representing a factor in a Taguchi design.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{values}}{A vector containing the levels or values associated with the factor. Default is \code{NA}.}

\item{\code{name}}{A character string specifying the name of the factor. Default is an empty string \code{``}.}

\item{\code{unit}}{A character string specifying the unit of measurement for the factor. Default is an empty string \code{``}.}

\item{\code{type}}{A character string specifying the type of the factor, which can be either \code{`numeric`} or \code{`categorical`}. Default is \code{`numeric`}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-taguchiFactor-attributes}{\code{taguchiFactor$attributes()}}
\item \href{#method-taguchiFactor-.values}{\code{taguchiFactor$.values()}}
\item \href{#method-taguchiFactor-.unit}{\code{taguchiFactor$.unit()}}
\item \href{#method-taguchiFactor-names}{\code{taguchiFactor$names()}}
\item \href{#method-taguchiFactor-clone}{\code{taguchiFactor$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-taguchiFactor-attributes"></a>}}
\if{latex}{\out{\hypertarget{method-taguchiFactor-attributes}{}}}
\subsection{Method \code{attributes()}}{
Get the attributes of the factor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{taguchiFactor$attributes()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-taguchiFactor-.values"></a>}}
\if{latex}{\out{\hypertarget{method-taguchiFactor-.values}{}}}
\subsection{Method \code{.values()}}{
Get and set the \code{values} for the factors in an object of class \code{taguchiFactor}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{taguchiFactor$.values(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{New values, If missing value get the \code{values}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-taguchiFactor-.unit"></a>}}
\if{latex}{\out{\hypertarget{method-taguchiFactor-.unit}{}}}
\subsection{Method \code{.unit()}}{
Get and set the \code{units} for the factors in an object of class \code{taguchiFactor}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{taguchiFactor$.unit(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{New unit, If missing value get the \code{units}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-taguchiFactor-names"></a>}}
\if{latex}{\out{\hypertarget{method-taguchiFactor-names}{}}}
\subsection{Method \code{names()}}{
Get and set the \code{names} in an object of class \code{taguchiFactor}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{taguchiFactor$names(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{New names, If missing value get the \code{names}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-taguchiFactor-clone"></a>}}
\if{latex}{\out{\hypertarget{method-taguchiFactor-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{taguchiFactor$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
