% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raw_process.R
\name{ad.correct}
\alias{ad.correct}
\title{Correct allele depth values}
\usage{
ad.correct(
  het.table,
  gt.table = NULL,
  odd.correct = TRUE,
  verbose = TRUE,
  parallel = FALSE
)
}
\arguments{
\item{het.table}{allele depth table generated from the function
\code{hetTgen}}

\item{gt.table}{genotype table generated from the function hetTgen}

\item{odd.correct}{logical, to correct for odd number anomalies in AD values.
default \code{TRUE}}

\item{verbose}{logical. show progress. Default \code{TRUE}}

\item{parallel}{logical. whether to parallelize the process}
}
\value{
Returns the coverage corrected allele depth table similar to the
output of \code{hetTgen}
}
\description{
A function to correct depth values with odd number of coverage values due to
sequencing anomalies or miss classification where genotype is homozygous and
depth values indicate heterozygosity.
The function adds a value of one to the allele with the lowest depth value
for when odd number anomalies or make the depth value zero for when
miss-classified. The genotype table must be provided for the latter.
}
\examples{
\dontrun{adc<-ad.correct(ADtable)}

}
\author{
Piyal Karunarathne
}
