% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raw_process.R
\name{hetTgen}
\alias{hetTgen}
\title{Generate allele depth or genotype table}
\usage{
hetTgen(
  vcf,
  info.type = c("AD", "AD-tot", "GT", "GT-012", "GT-AB", "DP"),
  verbose = TRUE,
  parallel = FALSE
)
}
\arguments{
\item{vcf}{an imported vcf file in a list using \code{readVCF}}

\item{info.type}{character. \code{AD}: allele depth value, \code{AD-tot}:total
allele depth, \code{DP}=unfiltered depth (sum), \code{GT}: genotype,
\code{GT-012}:genotype in 012 format, \code{GT-AB}:genotype in AB format.
Default \code{AD},  See details.}

\item{verbose}{logical. whether to show the progress of the analysis}

\item{parallel}{logical. whether to parallelize the process}
}
\value{
Returns a data frame of allele depth, genotype of SNPs for all the
individuals extracted from a VCF file
}
\description{
hetTgen extracts the read depth and coverage values for each snp for all
the individuals from a vcf file generated from readVCF (or GatK
VariantsToTable: see details)
}
\details{
If you generate the depth values for allele by sample using GatK
VariantsToTable option, use only -F CHROM -F POS -GF AD flags to generate
the table. Or keep only the CHROM, POS, ID, ALT, and individual AD columns.
For info.type \code{GT} option is provided to extract the genotypes of
individuals by snp.
}
\examples{
\dontrun{vcf.file.path <- paste0(path.package("rCNV"), "/example.raw.vcf.gz")
vcf <- readVCF(vcf.file.path=vcf.file.path)
het.table<-hetTgen(vcf)}

}
\author{
Piyal Karunarathne, Klaus Schliep
}
