% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post_detect.R
\name{vst}
\alias{vst}
\title{Calculate population-wise Vst}
\usage{
vst(AD, pops, id.list = NULL, qGraph = TRUE, verbose = TRUE, ...)
}
\arguments{
\item{AD}{data frame of total allele depth values of (duplicated, if
\code{id.list} is not provided) SNPs}

\item{pops}{character. A vector of population names for each individual.
Must be the same length as the number of samples in AD}

\item{id.list}{character. A vector of duplicated SNP IDs. Must match the IDs
in the AD data frame}

\item{qGraph}{logical. Plot the network plot based on Vst values
(see details)}

\item{verbose}{logical. show progress}

\item{\dots}{additional arguments passed to \code{qgraph}}
}
\value{
Returns a matrix of pairwise Vst values for populations
}
\description{
This function calculates Vst (variant fixation index) for populations given
a list of duplicated loci
}
\details{
Vst is calculated with the following equation
\deqn{V_{T} = \frac{ V_{S} }{V_{T}}} where VT is the variance of normalized
read depths among all individuals from the two populations and VS is the
average of the variance within each population, weighed for population size
(see reference for more details)
See \code{qgraph} help for details on qgraph output
}
\examples{
\dontrun{data(alleleINF)
data(ADtable)
DD<-dupGet(alleleINF)
ds<-DD[DD$dup.stat=="deviant",]
ad<-ADtable[match(paste0(ds$CHROM,".",ds$POS),paste0(ADtable$CHROM,".",ADtable$POS)),]
vst(ad,pops=substr(colnames(ad)[-c(1:4)],1,11))}

}
\references{
Redon, Richard, et al. Global variation in copy number in the human genome.
nature 444.7118 (2006)
}
\author{
Piyal Karunarathne
}
