% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rCoinBase.R
\name{cb_mkt_order}
\alias{cb_mkt_order}
\title{Spot: Place Market Order}
\usage{
cb_mkt_order(client_order_id = cb_get_order_id(), product_id, side, base_size)
}
\arguments{
\item{client_order_id}{= (string) A unique ID provided for the order (used for identification purposes) Example: 0000-00000-000000}

\item{product_id}{= (string) The trading pair (e.g. 'BTC-USD'). Example: BTC-USD}

\item{side}{= (string) The side of the market that the order is on (e.g. 'BUY', 'SELL'). Possible values: BUY, SELL}

\item{base_size}{= (string) The amount of the first Asset in the Trading Pair. Example: 0.001}
}
\value{
returns order details as a \code{data.frame} for market orders
}
\description{
Spot: Place Market Order
}
\examples{
\dontrun{
  cb_mkt_order(product_id = "BTC-USD", side = "BUY", base_size = '0.00001')
}
}
