% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Interval.R
\name{isOverlap}
\alias{isOverlap}
\title{isOverlap}
\usage{
isOverlap(theObject, someNumbers)
}
\arguments{
\item{theObject}{an Interval object}

\item{someNumbers}{a vector of one or two numbers to test overlap.
If two numbers are provided, they are treated as an interval (start, end)}
}
\value{
a logical value TRUE or FALSE
}
\description{
Method for checking if an interval is overlapping with a single number (start = end)
or a pair of numbers (start < end). A pair of intervals (start1, end1) and (start2, end2)
are overlapping if (end2 >= start1 and start2 <= end1).
}
\examples{
i1 <- new("Interval", start=1.1, end=1.2, key="dummy")
isOverlap(i1, c(1.0, 1.5))
isOverlap(i1, 1.0)
\dontrun{
isOverlap(i1, c(2.0, 1.5))  # generate an error
isOverlap(i1, c(1.0, 1.5, 2))  # generate an error
}

}
