% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IntervalTree.R
\docType{methods}
\name{overlapQuery,IntervalTree,numeric-method}
\alias{overlapQuery,IntervalTree,numeric-method}
\title{overlapQuery}
\usage{
\S4method{overlapQuery}{IntervalTree,numeric}(theObject, anInterval)
}
\arguments{
\item{theObject}{an IntervalTree object}

\item{anInterval}{a vector of one or two numbers to check overlap, if two numbers are provided,
they are treated as an interval (start, end).}
}
\value{
a list of vectors. Each vector contains information about an interval (name, start, end).
}
\description{
Method for searching an IntervalTree object. Given a number or an ordered pair of numbers denoting the
start and end of an interval, all intervals that overlapping the query interval in the IntervalTree
object will be retrieved.
}
\examples{
m_ranges <- data.frame(c("A","B","C","D","E","F"), c(-1.1,2,3,4,20,200), c(5,4,6,10,21.2,400))

m_interval_tree <- new("IntervalTree", data=m_ranges, root=list())
overlapQuery(m_interval_tree, 4)
res <- overlapQuery(m_interval_tree, c(2.5,7))
res
}
