% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msc.quality.R
\name{msc.quality}
\alias{msc.quality}
\title{Check the quality of the assembly}
\usage{
msc.quality(mapstats, groups)
}
\arguments{
\item{mapstats}{a character vector containing the file names of mapping statistics generated by KOMICS. These files provide information about the mapping and quality of the assembled minicircles.}

\item{groups}{a vector specifying the groups (e.g., species) to which the samples belong.}
}
\value{
\item{all}{a table merging the mapping statistics of all samples. The mapping statistics include the number of mapped reads (MR), mapped reads with high quality (MR_HQ), CSB3-containing mapped reads (MR_CSB3), and CSB3-containing mapped reads with high quality (MR_CSB3_HQ).}
\item{proportions}{a list of tables containing the proportions of the mentioned mapping statistics. It provides insights into the relative frequencies and proportions of each category.}
\item{plots}{barplots visualizing the mapping statistics and proportions. These plots help visualize and compare the mapping quality across samples.}
}
\description{
The msc.quality function allows you to summarize mapping statistics generated by KOMICS to assess the quality of minicircle assembly and mapping. It focuses on examining the frequencies of various mapped read categories, including read frequency, mapped read frequency, high-quality mapped read frequency, and the proportion of (near-)perfect alignments of CSB3-containing reads.
}
\examples{
data(exData)

### run function
map <- msc.quality(mapstats = system.file("extdata", exData$mapstats, package = "rKOMICS"),
                   exData$species)

lapply(map$proportions, mean)$MR_HQ 
lapply(map$proportions, mean)$MR_CSB3_HQ

### visualize results
barplot(map$proportions$MR)

}
