% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AbstractODESolver.R
\docType{class}
\name{AbstractODESolver-class}
\alias{AbstractODESolver-class}
\alias{.AbstractODESolver}
\alias{AbstractODESolver}
\alias{step,AbstractODESolver-method}
\alias{getODE,AbstractODESolver-method}
\alias{setStepSize,AbstractODESolver-method}
\alias{init,AbstractODESolver-method}
\alias{init<-,AbstractODESolver-method}
\alias{getStepSize,AbstractODESolver-method}
\alias{AbstractODESolver,missing-method}
\alias{AbstractODESolver,ODE-method}
\title{AbstractODESolver class}
\usage{
AbstractODESolver(ode, ...)

\S4method{step}{AbstractODESolver}(object, ...)

\S4method{getODE}{AbstractODESolver}(object, ...)

\S4method{setStepSize}{AbstractODESolver}(object, stepSize, ...)

\S4method{init}{AbstractODESolver}(object, stepSize, ...)

\S4method{init}{AbstractODESolver}(object, ...) <- value

\S4method{getStepSize}{AbstractODESolver}(object, ...)

\S4method{AbstractODESolver}{missing}(ode, ...)

\S4method{AbstractODESolver}{ODE}(ode, ...)
}
\arguments{
\item{ode}{an ODE object}

\item{...}{additional parameters}

\item{object}{a class object}

\item{stepSize}{the size of the step}

\item{value}{the step size value}
}
\description{
Defines the basic methods for all the ODE solvers.

AbstractODESolver generic

AbstractODESolver constructor missing

AbstractODESolver constructor ODE. Uses this constructor when ODE object is passed
}
\details{
Inherits from: ODESolver class
}
\examples{
# This is how we start defining a new ODE solver: Euler
.Euler <- setClass("Euler",              # Euler solver very simple; no slots
     contains = c("AbstractODESolver"))



# Here we define the ODE solver Verlet
.Verlet <- setClass("Verlet", slots = c(
    rate1 = "numeric",                          # Verlet calculates two rates
    rate2 = "numeric",
    rateCounter = "numeric"),
contains = c("AbstractODESolver"))



# This is the definition of the ODE solver Runge-Kutta 4
.RK4 <- setClass("RK4", slots = c(       # On the other hand RK4 uses 4 rates
   rate1 = "numeric",
   rate2 = "numeric",
   rate3 = "numeric",
   rate4 = "numeric",
   estimated_state = "numeric"),         # and estimates another state
contains = c("AbstractODESolver"))

}
