% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rPublic.R
\name{rp_preOrder_singleLeg}
\alias{rp_preOrder_singleLeg}
\title{Preflight Single-Leg}
\usage{
rp_preOrder_singleLeg(
  accountId,
  ticker,
  symType,
  side = NULL,
  ordType = NULL,
  timeInForce = NULL,
  expirationTime = NULL,
  qty = NULL,
  amt = NULL,
  lmtPrc = NULL,
  stopPrc = NULL,
  openCloseIndicator = NULL
)
}
\arguments{
\item{accountId}{= Public Brokerage Account Number}

\item{ticker}{= Ticker symbol: Ex. "SPY"}

\item{symType}{= Ticker Type: Ex. 'EQUITY','OPTION','MULTI_LEG_INSTRUMENT', 'CRYPTO', 'ALT','TREASURY', 'BOND', 'INDEX'}

\item{side}{= The Order Side BUY/SELL. For Options also include the openCloseIndicator. Ex. 'BUY' OR 'SELL'}

\item{ordType}{= The Type of order: Ex. 'MARKET','LIMIT', 'STOP', 'STOP_LIMIT'}

\item{timeInForce}{= The time in for the order: Ex. 'DAY' OR 'GTD"}

\item{expirationTime}{= The expiration date. Only used when timeInForce is GTD, cannot be more than 90 days in the future}

\item{qty}{= The order quantity. Used when buying/selling whole shares and when selling fractional. Mutually exclusive with amount}

\item{amt}{= The order amount. Used when buying/selling shares for a specific notional value}

\item{lmtPrc}{= The limit price. Used when orderType = LIMIT or orderType = STOP_LIMIT}

\item{stopPrc}{= The stop price. Used when orderType = STOP or orderType = STOP_LIMIT}

\item{openCloseIndicator}{= Used for options only. Indicates if this is BUY to OPEN/CLOSE}
}
\value{
Calculates the estimated financial impact of a potential trade before execution and returns as a \code{data.frame}.
}
\description{
Preflight Single-Leg
}
\examples{
\dontrun{
 # Fetches costs associated with the type of order being placed
 my_acc <- rp_getAccts()
 rp_preOrder_singleLeg(accountId = my_acc$accountId, ticker = "SPY250815C00633000", 
                       symType = "OPTION", side = "BUY", ordType = "MARKET", 
                       timeInForce = "DAY", qty = 1, openCloseIndicator = "OPEN")

 rp_preOrder_singleLeg(accountId = my_acc$accountId, ticker = "TSLA", 
                       symType = "EQUITY", side = "BUY", ordType = "MARKET",
                       timeInForce = "DAY", qty = 0.50, 
                       openCloseIndicator = "OPEN")
}
}
