% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/settest.R
\name{setTest}
\alias{setTest}
\title{setTest}
\usage{
setTest(pvalue, featureIDs, data, set, testype, testvalue)
}
\arguments{
\item{pvalue}{The vector of p-values. It can be the name of the covariate representing the Vector of
raw p-values in the \code{data} or a single vector but in the latter case it should match the
\code{featureIDs} vector}

\item{featureIDs}{The vector of feature IDs. It can be the name of the covariate representing the IDs in the
\code{data} or a single vector but in the latter case it should match the \code{pvalue} vector}

\item{data}{Optional data frame or matrix containing the variables in \code{pvalue} and \code{featureIDs}}

\item{set}{The selection of features defining the feature-set based on the the \code{featureIDs}.
If missing, the set of all features is selected}

\item{testype}{Character, type of the test: "selfcontained" or "competitive". Choosing the self-contained
option will automatically set the threshold to zero and the \code{testvalue} is ignored. Choosing the
competitive option without a \code{testvalue} will set the threshold to the overall estimated proportion
of true hypotheses}

\item{testvalue}{Optional value to test against. Setting this value to c along with
\code{testype=="competitive"} will lead to testing the null hypothesis against a threshold c.
Note: this value needs to be a proportion}
}
\value{
The adjusted p-value of the specified test for the feature-set is returned.
}
\description{
calculates the adjusted p-value for the local hypothesis as defined by \code{testtype}
and \code{testvalue}.
}
\examples{

\dontrun{
#Generate a vector of pvalues
set.seed(159)

m<- 100
pvalues <- runif(m,0,1)^5
featureIDs <- as.character(1:m)

# perform a self-contained test for all features
settest(pvalues, featureIDs, testype = "selfcontained")

# create a random pathway of size 60
randset=as.character(c(sample(1:m, 60)))

# perform a competitive test for the random pathway
settest(pvalues, featureIDs, set=randset, testype = "competitive")

# perform a unified null hypothesis test against 0.2 for a set of size 50
settest(pvalues, featureIDs, set=randset, testype = "competitive", testvalue = 0.2 )

}
}
\references{
Mitra Ebrahimpoor, Pietro Spitali, Kristina Hettne, Roula Tsonaka, Jelle Goeman,
Simultaneous Enrichment Analysis of all Possible Gene-sets: Unifying Self-Contained
and Competitive Methods, Briefings in Bioinformatics, , bbz074, https://doi.org/10.1093/bib/bbz074
}
\seealso{
\code{\link{setTDP}} \code{\link{SEA}}
}
\author{
Mitra Ebrahimpoor

\email{m.ebrahimpoor@lumc.nl}
}
