% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lcov.R
\name{lcovPca2}
\alias{lcovPca2}
\title{Improved Principal Component Analysis on a covariance object}
\usage{
lcovPca2(lcov, dimRange = NULL)
}
\arguments{
\item{lcov}{A list that contains all information about the handled covariance-structure}

\item{dimRange}{A number or vector for dimensionality reduction: \cr 
if it is a number: only the first components 1:dimRange are kept (those with largest eigenvalues)\cr            
if it is a range: only the components in the range dimRange[1]..dimRange[2] are kept}
}
\value{
returns a list: 
  $W is the whitening matrix, $DW the dewhitening matrix and $D an array
  containing a list of the eigenvalues. $kvar contains the total
  variance kept in percent.
}
\description{
Performs PCA _and_ whitening
  on the covariance object referenced by lcov. \cr \cr
  Difference to LCOV_PCA: null the rows of W (columns of DW) where the 
  corresponding eigenvalue in D is close to zero (more precisely: if
  lam/lam_max < EPS = 1e-7). This is numerically stable in the case where
  the covariance matrix is singular.\cr
 - Author: Wolfgang Konen, Cologne Univ., May'2009
}
\note{
lcovFix(lcov) has to be used before this function is applied
}
\seealso{
\code{\link{lcovFix}} \code{\link{lcovPca}}
}
\keyword{internal}
