% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{calculateSRDDistribution}
\alias{calculateSRDDistribution}
\title{calculateSRDDistribution}
\usage{
calculateSRDDistribution(
  data_matrix,
  option = "f",
  tie_probability = 0,
  output_to_file = FALSE
)
}
\arguments{
\item{data_matrix}{A DataFrame.}

\item{option}{A char to specify how ties are generated in the simulation.
The following options are available:
\itemize{
\item 'n': There are no ties for the solution vectors, the reference vector is fixed.
\item 'r': There are no ties. Both the column vector and the reference are generated randomly.
\item 't': Ties occur with a fixed probability specified by the user for both the solution vectors and the reference vector.
\item 'p': Ties occur with a fixed probability specified by the user for the solution vectors, the reference vector is fixed.
\item 'd': Tie distribution reflects the tie frequencies displayed by the solution vectors, the reference vector is fixed.
\item As default (recommended): Tie distribution reflects the tie frequencies displayed in the reference, the reference vector is fixed.
}}

\item{tie_probability}{The probability with which ties can occur.}

\item{output_to_file}{Boolean flag to enable file output.}
}
\value{
A List containing the SRD distribution and related descriptive statistics. xx1 value 
indicates the 5 percent significance threshold. SRD values falling between xx1 and xx19 are not 
distinguishable from SRD scores of random rankings, while an SRD score higher than xx19 indicates 
that the solution ranks the objects in a reverse order (with 5 percent significance).
}
\description{
R interface to calculate the SRD distribution that corresponds to the data.
}
\examples{
\donttest{
df <- data.frame(
A=c(32, 52, 44, 44, 47),
B=c(73, 75, 65, 76, 70),
C=c(60, 59, 57, 55, 60),
D=c(35, 24, 44, 83, 47),
E=c(41, 52, 46, 50, 65))

calculateSRDDistribution(df, option = 'p', tie_probability = 0.5)
}
}
\author{
Balázs R. Sziklai \email{sziklai.balazs@krtk.hu}, Linus Olsson \email{linusmeol@gmail.com}
}
