% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heatmap.R
\name{plotHeatmapSRD}
\alias{plotHeatmapSRD}
\title{plotHeatmapSRD}
\usage{
plotHeatmapSRD(df, output_to_file = FALSE, color = utilsColorPalette)
}
\arguments{
\item{df}{A DataFrame.}

\item{output_to_file}{Logical. If true, the distance matrix will be saved to the hard drive.}

\item{color}{Vector of colors used for the image. Defaults to colors \code{utilsColorPalette}.}
}
\value{
Returns a heatmap and the corresponding distance matrix.
}
\description{
Heatmap is generated based on the pairwise distance - measured in SRD - of the columns. 
Each column is set as reference once, then SRD values are calculated for the other columns.
}
\examples{
srdInput <- data.frame(
A=c(32, 52, 44, 44, 47),
B=c(73, 75, 65, 76, 70),
C=c(60, 59, 57, 55, 60),
D=c(35, 24, 44, 83, 47),
E=c(41, 52, 46, 50, 65))

plotHeatmapSRD(srdInput)

mycolors<- c("#e3f2fd", "#bbdefb", "#90caf9","#64b5f6","#42a5f5",
             "#2196f3","#1e88e5","#1976d2","#1565c0","#0d47a1")
plotHeatmapSRD(srdInput, color=mycolors)

}
\author{
Attila Gere \email{gereattilaphd@gmail.com}, Linus Olsson \email{linusmeol@gmail.com}, Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
