% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tephra3D.R
\name{TopoInterp}
\alias{TopoInterp}
\title{Topography Interpolation}
\usage{
TopoInterp(x, y, TOPO = NULL, N = 10)
}
\arguments{
\item{x}{Easting of point to interpolate [same units as TOPO$x, TOPO$y]}

\item{y}{Northing of point to interpolate [same units as TOPO$x, TOPO$y]}

\item{TOPO}{DEM: list containing vectors x and y and matrix z with dimensions (length(x), length(y))}

\item{N}{Smoothing parameter, must be positive. Larger N means less smoothing.}
}
\description{
Interpolates elevation at point (x, y) given Digital Elevation Model (DEM).
}
\examples{
data(VILL)
contour(VILL, xlim = c(-500, 500), ylim = c(-500, 500))
TopoInterp(0, 0, VILL) # interpolate elevation at point (0, 0)
}
\keyword{misc}
