% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/racircalcheck.R
\name{racircalcheck}
\alias{racircalcheck}
\title{Allows visual checking of rapid A/Ci response (RACiR) calibration data using
empty chamber data.}
\usage{
racircalcheck(
  data,
  mincut,
  maxcut,
  varnames = list(A = "A", Ca = "Ca", CO2_r = "CO2_r", E = "E", gtc = "gtc")
)
}
\arguments{
\item{data}{Data frame with the calibration (empty chamber) rapid A/Ci response}

\item{mincut}{Minimum cutoff value for reference CO2 (CO2_r). Used to cut
out the data from the initial chamber mixing. Default value is set to the
minimum COR_r value.}

\item{maxcut}{Maximum cutoff value for reference CO2 (CO2_r). Used to cut
out the data from the end of the response. Not needed in all cases. Default
value is set to the maximum COR_r value.}

\item{varnames}{Variable names - this allows for the use of this code with
other machines and setups where variable names may differ.}
}
\value{
racircalcheck allows visual checking of RACiR calibration data
}
\description{
\code{racircalcheck} Used to check range of calibration file. Produces
diagnostic graphs of A vs. Ci for quality control. Output includes plots
for checking and confirming cutoff values, and a plot with the fit, as well
as information as to which polynomial fit the data best.
}
\examples{
\donttest{
#Read in the file
data <- read_6800(system.file("extdata", "cal", package = "racir"))
#Run calibration check
racircalcheck(data = data,
              mincut = 350,
              maxcut = 780)
}

}
