% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix_rank.R
\name{matrix_rank}
\alias{matrix_rank}
\alias{matrix_rank.default}
\alias{matrix_rank.matrix}
\alias{matrix_rank.data.frame}
\title{Matrix Rank}
\usage{
matrix_rank(x, tol)

\method{matrix_rank}{default}(x, tol)

\method{matrix_rank}{matrix}(x, tol)

\method{matrix_rank}{data.frame}(x, tol)
}
\arguments{
\item{x}{A \link{matrix}.}

\item{tol}{Threshold below which SVD values are considered zero.}
}
\description{
Compute the rank of a matrix using the singular value decomposition (SVD)
method.
}
\details{
The singular value decomposition (SVD) method simply computes the SVD of \code{x}
and returns the number of singular values of \code{x} that are greater than
\code{tol}. See \code{\link[Matrix:rankMatrix]{Matrix::rankMatrix()}} for alternative methods.
}
\examples{
matrix_rank(1:5)
matrix_rank(randn(2, 2))
matrix_rank(cbind(c(1, 1, 1), c(2, 2, 2)))
matrix_rank(ones(3, 3))
matrix_rank(zeros(3, 5))
}
