% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convenience.R
\name{meshgrid}
\alias{meshgrid}
\title{Rectangular 2-D Grid}
\usage{
meshgrid(x, y = x)
}
\arguments{
\item{x}{Numeric vector representing the first coordinate of the grid.}

\item{y}{Numeric vector representing the second coordinate of the grid.}
}
\value{
A list of matrices.
}
\description{
Creates matrices for vectorized evaluations of 2-D scalar/vector fields over
2-D grids.
}
\examples{
mg <- meshgrid(linspace(-4 * pi, 4 * pi, 27)) # list of input matrices
z <- cos(mg[[1]]^2 + mg[[2]]^2) * exp(-sqrt(mg[[1]]^2 + mg[[2]]^2) / 6)
image(z, axes = FALSE) # color image
contour(z, add = TRUE, drawlabels = FALSE) # add contour lines
}
\seealso{
\code{\link[=expand.grid]{expand.grid()}}, \code{\link[=outer]{outer()}}.
}
