% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot.calibramp}
\alias{plot.calibramp}
\alias{rampplot}
\title{Visualize a calibrated color ramp}
\usage{
\method{plot}{calibramp}(x, ...)

rampplot(
  x,
  breaks = FALSE,
  breaklabs = TRUE,
  axis.args = list(side = 2),
  ylab = "z",
  xlab = ""
)
}
\arguments{
\item{x}{The calibirated color ramp object (\code{calibramp}-class object).}

\item{...}{Arguments passed to the \code{rampplot} function.}

\item{breaks}{Should the distribution of breaks be visualized?}

\item{breaklabs}{Should the minimum and maximum break labels be visualized?}

\item{axis.args}{Arguments passed to the axis function.}

\item{ylab}{y-axis label.}

\item{xlab}{x-axis label.}
}
\value{
The functions have no return values.
}
\description{
The method can be used to inspect and visualize calbirated color ramp object.
}
\examples{
# the paleomap ramp
data(paleomap)
plot(paleomap)
# 0-calibrated, expanded ramp
tiepoints <- data.frame(z=c(c(-1, -0.1, 0, 0.1, +1)), color=gradinv(5))
ramp <- expand(tiepoints, n=255)
plot(ramp)
}
