% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/radqlqc.R
\name{h_adqlqc}
\alias{h_adqlqc}
\alias{get_qs_data}
\alias{get_random_dates_between}
\alias{prep_adqlqc}
\alias{calc_scales}
\alias{derv_chgcat1}
\alias{comp_derv}
\title{Helper Functions for Constructing ADQLQC}
\usage{
get_qs_data(
  adsl,
  visit_format = "CYCLE",
  n_assessments = 5L,
  n_days = 1L,
  lookup = NULL,
  seed = NULL,
  na_percentage = 0,
  na_vars = list(QSORRES = c(1234, 0.2), QSSTRESC = c(1234, 0.2))
)

get_random_dates_between(from, to, visit_id)

prep_adqlqc(df)

calc_scales(adqlqc1)

derv_chgcat1(dataset)

comp_derv(dataset, percent, number)
}
\arguments{
\item{adsl}{(\code{data.frame})\cr Subject-Level Analysis Dataset (ADSL).}

\item{visit_format}{(\code{character})\cr Type of visit. Options are "WEEK" and "CYCLE".}

\item{n_assessments}{(\code{integer})\cr Number of weeks or cycles.}

\item{n_days}{(\code{integer})\cr Number of days in each cycle (only used if \code{visit_format} is "CYCLE").}

\item{lookup}{(\code{data.frame})\cr Additional parameters.}

\item{seed}{(\code{numeric})\cr Seed to use for reproducible random number generation.}

\item{na_percentage}{(\code{proportion})\cr Default percentage of values to be replaced by \code{NA}.}

\item{na_vars}{(\code{list})\cr A named list where the name of each element is a column name of \code{ds}. Each
element of this list should be a numeric vector with two elements:
\itemize{
\item{\code{seed} (\code{numeric})\cr The seed to be used for this element - can be \code{NA}.}
\item{\code{percentage} (\code{proportion})\cr Percentage of elements to be replaced with \code{NA}.
If \code{NA}, \code{na_percentage} is used as a default.}
}}

\item{from}{(\verb{datetime vector})\cr Start date/times.}

\item{to}{(\verb{datetime vector})\cr End date/times.}

\item{visit_id}{(\code{vector})\cr Visit identifiers.}

\item{df}{(\code{data.frame})\cr SDTM QS dataset.}

\item{adqlqc1}{(\code{data.frame})\cr Prepared data generated from the \code{\link[=prep_adqlqc]{prep_adqlqc()}} function.}

\item{dataset}{(\code{data.frame})\cr Dataset.}

\item{percent}{(\code{numeric})\cr Completion - Completed at least y percent of questions, 1 record per visit}

\item{number}{(\code{numeric})\cr Completion - Completed at least x question(s), 1 record per visit}
}
\value{
a dataframe with SDTM questionnaire data

Data frame with new randomly generated dates variable.

\code{data.frame}

\code{data.frame}

\code{data.frame}

\code{data.frame}
}
\description{
Internal functions used by \code{radqlqc}.
}
\section{Functions}{
\itemize{
\item \code{get_qs_data()}: Questionnaires EORTC QLQ-C30 V3.0 SDTM (QS)

Function for generating random Questionnaires SDTM domain

\item \code{get_random_dates_between()}: Function for generating random dates between 2 dates

\item \code{prep_adqlqc()}: Prepare ADaM ADQLQC data, adding PARAMCD to SDTM QS data

\item \code{calc_scales()}: Scale calculation for ADQLQC data

\item \code{derv_chgcat1()}: Calculate Change from Baseline Category 1

\item \code{comp_derv()}: Completion/Compliance Data Calculation

}}
\examples{
adsl <- radsl(N = 10, study_duration = 2, seed = 1)
adqlqc <- radqlqc(adsl, seed = 1, percent = 80, number = 2)

}
\keyword{internal}
