% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/radex.R
\name{radex}
\alias{radex}
\title{Exposure Analysis Dataset (ADEX)}
\usage{
radex(
  adsl,
  param = c("Dose administered during constant dosing interval",
    "Number of doses administered during constant dosing interval",
    "Total dose administered", "Total number of doses administered"),
  paramcd = c("DOSE", "NDOSE", "TDOSE", "TNDOSE"),
  paramu = c("mg", " ", "mg", " "),
  parcat1 = c("INDIVIDUAL", "OVERALL"),
  parcat2 = c("Drug A", "Drug B"),
  visit_format = "WEEK",
  n_assessments = 5L,
  n_days = 5L,
  max_n_exs = 6L,
  lookup = NULL,
  seed = NULL,
  na_percentage = 0,
  na_vars = list(AVAL = c(NA, 0.1), AVALU = c(NA), 0.1),
  cached = FALSE
)
}
\arguments{
\item{adsl}{(\code{data.frame})\cr Subject-Level Analysis Dataset (ADSL).}

\item{param}{(\verb{character vector})\cr Parameter values.}

\item{paramcd}{(\verb{character vector})\cr Parameter code values.}

\item{paramu}{(\verb{character vector})\cr Parameter unit values.}

\item{parcat1}{(\verb{character vector})\cr Dose amount categories. Defaults to "Individual" and "Overall".}

\item{parcat2}{(\verb{character vector})\cr Types of drug received. Defaults to "Drug A" and "Drug B".}

\item{visit_format}{(\code{character})\cr Type of visit. Options are "WEEK" and "CYCLE".}

\item{n_assessments}{(\code{integer})\cr Number of weeks or cycles.}

\item{n_days}{(\code{integer})\cr Number of days in each cycle (only used if \code{visit_format} is "CYCLE").}

\item{max_n_exs}{(\code{integer})\cr Maximum number of exposures per patient. Defaults to 6.}

\item{lookup}{(\code{data.frame})\cr Additional parameters.}

\item{seed}{(\code{numeric})\cr Seed to use for reproducible random number generation.}

\item{na_percentage}{(\code{proportion})\cr Default percentage of values to be replaced by \code{NA}.}

\item{na_vars}{(\code{list})\cr A named list where the name of each element is a column name of \code{ds}. Each
element of this list should be a numeric vector with two elements:
\itemize{
\item{\code{seed} (\code{numeric})\cr The seed to be used for this element - can be \code{NA}.}
\item{\code{percentage} (\code{proportion})\cr Percentage of elements to be replaced with \code{NA}.
If \code{NA}, \code{na_percentage} is used as a default.}
}}

\item{cached}{boolean whether the cached ADEX data \code{cadex} should be returned or new data
should be generated. If set to \code{TRUE} then the other arguments to \code{radex} will be ignored.}
}
\value{
\code{data.frame}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Function for generating random Exposure Analysis Dataset for a given
Subject-Level Analysis Dataset.
}
\details{
One record per each record in the corresponding SDTM domain.

Keys: \code{STUDYID}, \code{USUBJID}, \code{EXSEQ}, \code{PARAMCD}, \code{PARCAT1}, \code{ASTDTM}, \code{AENDTM}, \code{ASTDY}, \code{AENDY},
\code{AVISITN}, \code{EXDOSFRQ}, \code{EXROUTE}, \code{VISIT}, \code{VISITDY}, \code{EXSTDTC}, \code{EXENDTC}, \code{EXSTDY}, \code{EXENDY}
}
\examples{
adsl <- radsl(N = 10, study_duration = 2, seed = 1)

adex <- radex(adsl, seed = 2)
adex
}
