% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measure_importance.R
\name{important_variables}
\alias{important_variables}
\title{Extract k most important variables in a random forest}
\usage{
important_variables(
  importance_frame,
  k = 15,
  measures = names(importance_frame)[2:min(5, ncol(importance_frame))],
  ties_action = "all"
)
}
\arguments{
\item{importance_frame}{A result of using the function measure_importance() to a random forest or a randomForest object}

\item{k}{The number of variables to extract}

\item{measures}{A character vector specifying the measures of importance to be used}

\item{ties_action}{One of three: c("none", "all", "draw"); specifies which variables to pick when ties occur. When set to "none" we may get less than k variables, when "all" we may get more and "draw" makes us get exactly k.}
}
\value{
A character vector with names of k variables with highest sum of rankings
}
\description{
Get the names of k variables with highest sum of rankings based on the specified importance measures
}
\examples{
forest <- randomForest::randomForest(Species ~ ., data = iris, localImp = TRUE, ntree = 300)
important_variables(measure_importance(forest), k = 2)

}
