% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSD-Bias.R
\name{GSD_allocation}
\alias{GSD_allocation}
\title{Calculates the Type I error for different randomization sequences from a randomization procedure for a group sequential design}
\usage{
GSD_allocation(
  n,
  reps,
  sfu,
  K,
  rp,
  seed = 42,
  ui = "No",
  rb = 4,
  mti = 3,
  p = 2/3
)
}
\arguments{
\item{n}{total sample size}

\item{reps}{number of simulations to be conducted}

\item{sfu}{Group sequential design used (currently available: \code{"Pocock"} - Pocock, \code{"OF"} - O'Brien & Fleming,
\code{sfLDPocock} - Lan & DeMets with Pocock like alpha spending function,
\code{sfLDOF} - Lan & DeMets with O'Brien & Fleming like alpha spending function)}

\item{K}{number of stages}

\item{rp}{the randomization procedure used (currently available: \code{'"CR"'},
\code{'"RAR"'}, \code{'"BSD"'}, \code{'"CHEN"'}, \code{'"PBR"'}, \code{'"MP"'})}

\item{seed}{Randomization seed}

\item{ui}{for Lan & DeMets design. Update critical values after each stage according to allocation ratio observed if set to \code{"yes"}.}

\item{rb}{Block size for randomization procedure PBR.}

\item{mti}{Maximum tolerated imbalance for randomization procedure BSD and MP.}

\item{p}{Probability p in favor of the treatment with fewer allocations for EBC and CHEN.}
}
\value{
A list consisting of a vector of Type I errors for each randomization sequence generated from the randomization procedure and a S4 object of the class of the randomization procedure.
}
\description{
Calculates the Type I error for different randomization sequences from a randomization procedure for a group sequential design
}
\examples{
#Simulate a group sequential design according to O'Brien and Fleming's design with 24 patients,
#10 simulation runs,3 Stages using Random Allocation Rule as a randomization procedure.
GSD_allocation(n=24, reps=10, sfu="OF", K=3, rp="RAR")
#Simulate a group sequential design according to Lan and deMets design with a Pocock
#like alpha spending function with 18 patients, 10 simulation runs,
#3 Stages using Permuted Block Randomization with block size 4
#as a randomization procedure without updating the critical values after each stage.
library(gsDesign)
GSD_allocation(n=18, reps=10, sfu=sfLDPocock, K=3, rp="PBR", ui="no", rb=4)
}
