% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/class.R
\docType{class}
\name{RankInit-class}
\alias{RankInit}
\alias{RankInit-class}
\title{RankInit Class}
\description{
A S4 class to store initialization information of model fitting

The \code{RankInit} class is used to give initial values of model fitting procedures.
}
\section{Slots}{

\describe{
\item{\code{param.init}}{a list containing initial values of the positive parametrization of weights.}

\item{\code{modal_ranking.init}}{a list containing starting points for the modal ranking search.}

\item{\code{clu}}{an integer containing the number of clusters used in the model.}

\item{\code{p.init}}{a numeric vector containing the initial values for cluster probabilities.}
}}
\examples{
c1init = new("RankInit",param.init=list(rep(1,4)),
     modal_ranking.init=list(c(2,3,4,1,5)),clu=1L)
c2init = new("RankInit",param.init=list(rep(0.1,4),rep(0.1,4)),
     modal_ranking.init = list(c(2,3,4,1,5),c(2,5,1,4,3)),clu=2L,p.init=c(0.5,0.5))
}
\references{
Qian Z,  Yu L. H. P (2019) "Weighted Distance-Based Models for Ranking Data Using the R Package rankdist." \emph{Journal of Statistical Software}, \strong{90}(5), 1-31. doi: 10.18637/jss.v090.i05
}
\seealso{
\code{\link{RankData}}, \code{\link{RankControl}}
}

