% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Subfunctions.R
\name{select.VarsElements}
\alias{select.VarsElements}
\title{select.VarsElements}
\usage{
select.VarsElements(x, y, invert = FALSE)
}
\arguments{
\item{x}{data.frame, character vector or named numeric containing element abbreviations as variables}

\item{y}{optional, data.frame, character vector or named numeric containing element abbreviations as variables}

\item{invert}{logical. If TRUE return variable names that do not match an element abbreviation pattern}
}
\value{
character vector of element abbreviations
}
\description{
The function returns a character vector of element abbreviations if the input object contained variables with element abbreviations.
Input may be data.frame, matrix, character vector or named numeric.
There are two options to use this functions:
\itemize{
\item A) only one object
\item B) with two objects
}
For A) the function checks for the pattern of element abbreviations, e.g. Al, S, Ca, etc.
For B) the function checks for element abbreviations which are present in both objects. E.g. if x = c("Al", "Ba", "Ca") and y = c("Ba", "K", "Th") the return value will be "Ba".
The resulting character vector is without duplicated entries, e.g. x = c("N", "P", "S", "S") results into c("N", "P", "S").
}
\examples{
x = c("Al", "Ba", "Ca")
y = c("Ba", "K", "Th")
select.VarsElements(x, y)

myvector = c("Al", "Location", "Date", "S", "Ba", "OH")
select.VarsElements(myvector)
select.VarsElements(myvector, invert = TRUE)

}
\seealso{
Other sub functions: \code{\link{check_readline}},
  \code{\link{relError_dataset}}
}
\author{
Solveig Pospiech
}
