% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workflow-fsl_flirt.R
\name{cmd_run_fsl_flirt}
\alias{cmd_run_fsl_flirt}
\title{Run 'FSL' linear registration}
\usage{
cmd_run_fsl_flirt(
  subject,
  mri_path,
  ct_path,
  dof = 6,
  cost = c("mutualinfo", "leastsq", "normcorr", "corratio", "normmi", "labeldiff", "bbr"),
  search = 90,
  searchcost = c("mutualinfo", "leastsq", "normcorr", "corratio", "normmi", "labeldiff",
    "bbr"),
  overwrite = FALSE,
  command_path = NULL,
  dry_run = FALSE,
  verbose = dry_run
)
}
\arguments{
\item{subject}{'RAVE' subject or subject ID}

\item{mri_path}{path to 'MRI' (fixed image)}

\item{ct_path}{path to 'CT' (moving image)}

\item{dof}{degrees of freedom; default is 6 (rigid-body); set to 12 ('affine')}

\item{cost, searchcost}{cost function name}

\item{search}{search degrees; default is 90 to save time, set to 180 for
full search}

\item{overwrite}{overwrite existing files}

\item{command_path}{path to \code{'FSLDIR'} environment variable}

\item{dry_run}{whether to dry-run}

\item{verbose}{whether to print out command}
}
\value{
A command set running the terminal command; a \code{'coregistration'}
folder will be created under the subject imaging directory
}
\description{
Run 'FSL' linear registration
}
