% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/progress.R
\name{rave_progress}
\alias{rave_progress}
\title{'RAVE' progress}
\usage{
rave_progress(
  title,
  max = 1,
  ...,
  quiet = FALSE,
  session = get_shiny_session(),
  shiny_auto_close = FALSE,
  log = NULL
)
}
\arguments{
\item{title}{progress title}

\item{max}{maximum steps}

\item{...}{passed to shiny progress}

\item{quiet}{whether to suppress the progress}

\item{session}{shiny session}

\item{shiny_auto_close}{whether to automatically close the progress bar
when the parent function is closed}

\item{log}{alternative log function if not default (\code{\link{message}})}
}
\value{
A list of functions to control the progress bar
}
\description{
Automatically displays 'shiny' progress when shiny is present, or text
messages to track progress
}
\examples{


# Naive example
progress <- rave_progress(title = "progress", max = 10)
progress$inc("job 1")
progress$inc("job 2")
progress$close()

# Within function
slow_sum <- function(n = 11) {
  p <- rave_progress(title = "progress", max = n,
                     shiny_auto_close = TRUE)
  s <- 0
  for( i in seq(1, n) ) {
    Sys.sleep(0.1)
    p$inc(sprintf("adding \%d", i))
    s <- s + i
  }
  invisible(s)
}

slow_sum()



}
