% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_cornell.R
\name{generate_cornell}
\alias{generate_cornell}
\title{Generate Cornell Box}
\usage{
generate_cornell(
  light = TRUE,
  lightintensity = 5,
  lightcolor = "white",
  lightwidth = 332,
  lightdepth = 343,
  light_position = c(555/2, 554, 555/2),
  sigma = 0,
  leftcolor = "#1f7326",
  rightcolor = "#a60d0d",
  roomcolor = "#bababa",
  importance_sample = TRUE
)
}
\arguments{
\item{light}{Default `TRUE`. Whether to include a light on the ceiling of the box.}

\item{lightintensity}{Default `5`. The intensity of the light.}

\item{lightcolor}{Default `white`. The color the of the light.}

\item{lightwidth}{Default `332`. Width (z) of the light.}

\item{lightdepth}{Default `343`. Depth (x) of the light.}

\item{light_position}{Default `c(555/2,554,555/2)`. Position of the light.}

\item{sigma}{Default `0`. Oren-Nayar microfacet angle.}

\item{leftcolor}{Default `#1f7326` (green).}

\item{rightcolor}{Default `#a60d0d` (red).}

\item{roomcolor}{Default `#bababa` (light grey).}

\item{importance_sample}{Default `TRUE`. Importance sample the light in the room.}
}
\value{
Tibble containing the scene description of the Cornell box.
}
\description{
Generate Cornell Box
}
\examples{
#Generate and render the default Cornell box.
if(run_documentation()) {
render_scene(generate_cornell(), 
             samples=16,aperture=0, fov=40, ambient_light=FALSE, parallel=TRUE)
}
if(run_documentation()) {
#Make a much smaller light in the center of the room.
render_scene(generate_cornell(lightwidth=200,lightdepth=200), 
             samples=16,aperture=0, fov=40, ambient_light=FALSE, parallel=TRUE)
}
if(run_documentation()) {
#Place a sphere in the middle of the box.
scene = generate_cornell(lightwidth=200,lightdepth=200) \%>\%
  add_object(sphere(x=555/2,y=555/2,z=555/2,radius=555/4))
render_scene(scene, samples=16,aperture=0, fov=40, ambient_light=FALSE, parallel=TRUE)
}
if(run_documentation()) {
#Reduce "fireflies" by setting a clamp_value in render_scene()
render_scene(scene, samples=16,aperture=0, fov=40, ambient_light=FALSE, 
             parallel=TRUE,clamp_value=3)
}
if(run_documentation()) {
# Change the color scheme of the cornell box
generate_cornell(leftcolor="purple", rightcolor="yellow") |> 
  render_scene(samples=16,aperture=0, fov=40, ambient_light=FALSE, 
               parallel=TRUE,clamp_value=3)
}
}
