% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_canopy_openness.R
\name{compute_canopy_openness}
\alias{compute_canopy_openness}
\title{Calculate canopy openness}
\usage{
compute_canopy_openness(bin, z, a, m = NULL, angle_width = 10)
}
\arguments{
\item{bin}{logical \link[terra:SpatRaster-class]{terra::SpatRaster} with one layer. A binarized
hemispherical image. See \code{\link[=binarize_with_thr]{binarize_with_thr()}} for details.}

\item{z}{\link[terra:SpatRaster-class]{terra::SpatRaster} generated with \code{\link[=zenith_image]{zenith_image()}}.}

\item{a}{\link[terra:SpatRaster-class]{terra::SpatRaster} generated with \code{\link[=azimuth_image]{azimuth_image()}}.}

\item{m}{logical \link[terra:SpatRaster-class]{terra::SpatRaster} with one layer. A binary mask with
\code{TRUE} for selected pixels.}

\item{angle_width}{numeric vector of length one. Angle in deg that must
divide both 0–360 and 0–90 into an integer number of segments. Retrieve a
set of valid values by running
\code{lapply(c(45, 30, 18, 10), function(a) vapply(0:6, function(x) a/2^x, 1))}.}
}
\value{
Numeric vector of length one, constrained to the range \eqn{[0, 1]}.
}
\description{
Calculate canopy openness from a binarized hemispherical image with angular
coordinates.
}
\details{
Canopy openness is computed following the equation from
\insertCite{Gonsamo2011;textual}{rcaiman}:

\deqn{
CO = \sum_{i = 1}^{N} GF(\phi_i, \theta_i) \cdot \frac{\cos(\theta_{1,i}) -
 \cos(\theta_{2,i})}{n_i}
}

where \eqn{GF(\phi_i, \theta_i)} is the gap fraction in cell \eqn{i},
\eqn{\theta_{1,i}} and \eqn{\theta_{2,i}} are the lower and upper zenith
angles of the cell, \eqn{n_i} is the number of cells in the corresponding
zenith ring, and \eqn{N} is the total number of cells.

When a mask is provided via the \code{m} argument, the equation is adjusted to
compensate for the reduced area of the sky vault:

\deqn{
CO = \frac{\sum_{i=1}^{N} GF(\phi_i, \theta_i) \cdot w_i}
{\sum_{i=1}^{N} w_i}
\quad \text{with} \quad
w_i = \frac{\cos(\theta_{1,i}) - \cos(\theta_{2,i})}{n_i}
}

The denominator ensures that the resulting openness value remains
scale-independent. Without this normalization, masking would lead to
underestimation, as the numerator alone assumes full hemispherical coverage.
}
\examples{
caim <- read_caim()
z <- zenith_image(ncol(caim), lens())
a <- azimuth_image(z)
m <- select_sky_region(z, 0, 70)
bin <- binarize_with_thr(caim$Blue, thr_isodata(caim$Blue[m]))
plot(bin)
compute_canopy_openness(bin, z, a, m, 10)
}
\references{
\insertAllCited{}
}
