% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/background.R
\name{rcmdcheck_process}
\alias{rcmdcheck_process}
\title{Run an \verb{R CMD check} process in the background}
\description{
rcmdcheck_process is an R6 class, that extends the
\link[callr:rcmd_process]{callr::rcmd_process} class (which in turn extends \link[processx:process]{processx::process}.
}
\section{Usage}{
\preformatted{cp <- rcmdcheck_process$new(path = ".", args = character(),
         build_args = character(), check_dir = NULL,
         libpath = .libPaths(), repos = getOption("repos"))

cp$parse_results()
}

Other methods are inherited from \link[callr:rcmd_process]{callr::rcmd_process} and
\link[processx:process]{processx::process}.

Note that you calling the \code{get_output_connection} and
\code{get_error_connection} method on this is not a good idea, because
then the stdout and/or stderr of the process will not be collected
for \code{parse_results()}.

You can still use the \code{read_output_lines()} and \code{read_error_lines()}
methods to read the standard output and error, \code{parse_results()} is
not affected by that.
}

\section{Arguments}{

\itemize{
\item \code{cp}: A new rcmdcheck_process object.
\item \code{path}: Path to a package tree or a package archive file. This is the
package to check.
\item \code{args}: Command line arguments to \verb{R CMD check}.
\item \code{build_args}: Command line arguments to \verb{R CMD build}.
\item \code{check_dir}: Directory for the results.
\item \code{libpath}: The library path to set for the check.
\item \code{repos}: The \code{repos} option to set for the check.
This is needed for cyclic dependency checks if you use the
\code{--as-cran} argument. The default uses the current value.
\item \code{env}: A named character vector, extra environment variables to
set in the check process.
}
}

\section{Details}{

Most methods are inherited from \link[callr:rcmd_process]{callr::rcmd_process} and
\link[processx:process]{processx::process}.

\code{cp$parse_results()} parses the results, and returns an S3 object with
fields \code{errors}, \code{warnnigs} and \code{notes}, just like \code{\link[=rcmdcheck]{rcmdcheck()}}. It
is an error to call it before the process has finished. Use the
\code{wait()} method to wait for the check to finish, or the \code{is_alive()}
method to check if it is still running.
}

