% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recoding.R
\name{make_recode_query}
\alias{make_recode_query}
\title{Make a recoding call from linked codings}
\usage{
make_recode_query(linked_codings, from = 1, to_suffix = "to", ...)
}
\arguments{
\item{linked_codings}{A `linked_coding_df`}

\item{from}{A character or integer that selects the correct original coding.
Defaults to 1, the first linked coding.}

\item{to_suffix}{The suffix used to signify which columns refer to values to
which the vector will be recoded}

\item{...}{Any other parameters passed onto the recoding function selector}
}
\value{
A function with single argument when applied to an input vector
  will recode the vector appropriately
}
\description{
This creates a function that accepts a vector and recodes it from the
information provided in a `linked_coding_df`. Usually this is intended
for package authors who want to operate at the recoding relational
table level (e.g. mapping multiple codings to one). Most end users
should use [recode_vec()] instead.
}
\examples{
cdng_old <- coding(code("Yes", 1), code("No", 2))
cdng_new <- coding(code("Yes", 1), code("No", 0))
recode_func <- make_recode_query(link_codings(cdng_new, cdng_old))

vec <- sample(1:2, 20, replace = TRUE)
recode_func(vec)
}
