% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checking.R
\name{matches_coding}
\alias{matches_coding}
\alias{verify_matches_coding}
\title{Checks if vector's content adheres to a coding}
\usage{
matches_coding(vec, coding, ignore_empty = TRUE)

verify_matches_coding(vec, coding, ignore_empty = TRUE)
}
\arguments{
\item{vec}{A vector}

\item{coding}{A `coding` object}

\item{ignore_empty}{Logical flag to skip check if coding is empty}
}
\value{
TRUE/FALSE
}
\description{
Performs to check to see if the set of vector values are equal to or a subset
of a coding's values.
}
\section{Functions}{
\itemize{
\item \code{verify_matches_coding()}: Rather than returning TRUE/FALSE, this function
halts execution if `matches_coding()` returns FALSE.

}}
\examples{
vec1 <- sample(1:2, 10, replace = TRUE)
vec2 <- sample(0:1, 10, replace = TRUE)
cdng <- coding(code("Yes", 1), code("No", 0))
matches_coding(vec1, cdng)
matches_coding(vec2, cdng)
}
