% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdatacite-package.R
\docType{package}
\name{rdatacite-package}
\alias{rdatacite-package}
\alias{rdatacite}
\title{rdatacite}
\description{
DataCite R client
}
\section{HTTP Requests}{

All HTTP requests are GET requests, and are sent with the following
headers:
\itemize{
\item \verb{Accept: application/vnd.api+json; version=2}
\item \verb{User-Agent: r-curl/4.3 crul/0.9.0 rOpenSci(rdatacite/0.5.0)}
\item \verb{X-USER-AGENT: r-curl/4.3 crul/0.9.0 rOpenSci(rdatacite/0.5.0)}
}

The user-agent strings change as the versions of each package change.
}

\section{Methods in the package}{

\itemize{
\item \code{\link[=dc_providers]{dc_providers()}}
\item \code{\link[=dc_reports]{dc_reports()}}
\item \code{\link[=dc_check]{dc_check()}}
\item \code{\link[=dc_events]{dc_events()}}
\item \code{\link[=dc_dois]{dc_dois()}}
\item \code{\link[=dc_clients]{dc_clients()}}
\item \code{\link[=dc_client_prefixes]{dc_client_prefixes()}}
\item \code{\link[=dc_provider_prefixes]{dc_provider_prefixes()}}
\item \code{\link[=dc_status]{dc_status()}}
\item \code{\link[=dc_prefixes]{dc_prefixes()}}
\item \code{\link[=dc_activities]{dc_activities()}}
}
}

\section{rdatacite defunct functions}{

\itemize{
\item \code{dc_data_center}
\item \code{dc_data_centers}
\item \code{dc_facet}
\item \code{dc_member}
\item \code{dc_members}
\item \code{dc_mlt}
\item \code{dc_oai_getrecord}
\item \code{dc_oai_identify}
\item \code{dc_oai_listidentifiers}
\item \code{dc_oai_listmetadataformats}
\item \code{dc_oai_listrecords}
\item \code{dc_oai_listsets}
\item \code{dc_search}
\item \code{dc_stats}
\item \code{dc_work}
\item \code{dc_works}
}
}

\section{Content negotation}{

For content negotation see \code{rcrossref::cr_cn()}, which can be used for
Crossref, DataCite and Medra DOIs
}

\section{GraphGL API}{

rdatacite does not support the GraphGL API
https://support.datacite.org/docs/datacite-graphql-api-guide - we suggest
trying the \code{ghql} package (https://github.com/ropensci/ghql/)
}

\author{
Scott Chamberlain \email{myrmecocystus@gmail.com}
}
\keyword{package}
