% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.mfrd.R
\name{plot.mfrd}
\alias{plot.mfrd}
\title{Plot the Multivariate Frontier Regression Discontinuity}
\usage{
\method{plot}{mfrd}(
  x,
  model = c("m_s", "m_h", "m_t"),
  methodname = c("Param", "bw", "Half-bw", "Double-bw"),
  gran = 10,
  raw_data = TRUE,
  color_surface = FALSE,
  ...
)
}
\arguments{
\item{x}{An \code{mfrd} object returned by \code{mfrd_est} or contained in the object 
returned by \code{mrd_est}.}

\item{model}{A string containing the model specification. Options include one of \code{c("m_s", "m_h", "m_t")},
which denote the complete model, heterogeneous treatment model, and treatment only 
model, respectively.}

\item{methodname}{A string containing the method specification.
Options include one of \code{c("Param", "bw", "Half-bw", "Double-bw")}.}

\item{gran}{A non-negative integer specifying the granularity of the surface grid (i.e. the desired number of predicted points 
before and after the cutoff, along each assignment variable). The default is 10.}

\item{raw_data}{A logical value indicating whether the raw data points are plotted. The default is \code{TRUE}.}

\item{color_surface}{A logical value indicating whether the treated surface is colored. The default is \code{FALSE}.}

\item{...}{Additional graphic arguments passed to \code{persp}.}
}
\description{
\code{plot.mfrd} plots a 3D illustration of the bivariate frontier regression discontinuity design (RDD).
}
\examples{
set.seed(12345)
x1 <- runif(1000, -1, 1)
x2 <- runif(1000, -1, 1)
cov <- rnorm(1000)
y <- 3 + 2 * (x1 >= 0) + 3 * cov + 10 * (x2 >= 0) + rnorm(1000)
model <- mrd_est(y ~ x1 + x2, cutpoint = c(0, 0), t.design = c("geq", "geq"))
plot(model$front$tau_MRD, "m_s", "Param")
}
