% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/citation.R
\name{ddi_titlStmt}
\alias{ddi_titlStmt}
\alias{ddi_altTitl}
\alias{ddi_IDNo}
\alias{ddi_parTitl}
\alias{ddi_subTitl}
\title{titlStmt and its child nodes}
\usage{
ddi_titlStmt(...)

ddi_altTitl(...)

ddi_IDNo(...)

ddi_parTitl(...)

ddi_subTitl(...)
}
\arguments{
\item{...}{Child nodes or attributes.}
}
\value{
A ddi_node object.
}
\description{
Title statement for the work at the appropriate level: marked-up document;
marked-up document source; study; study description, other materials; other
materials for the study. Both \code{titlStmt} and \code{titl} are required elements in the \code{citation}
branch of a DDI-Codebook. More information on these elements, especially
their allowed attributes, can be found in the references.
}
\details{
\emph{Parent nodes}

\code{titlStmt} is contained in the following elements: \code{citation}; \code{docSrc};
\code{fileCitation}; and \code{sourceCitation}.

\emph{titlStmt specific child nodes}

\code{ddi_altTitl()} is the alternative title. A title by which the work is commonly referred, or an
abbreviation of the title.

\code{ddi_IDNo()} is the identification number. This is a unique string or number (producer's or
archive's number). Can be a DOI. An "agency" attribute is supplied. Identification Number
of data collection maps to Dublin Core Identifier element.

\code{ddi_parTitl()} is the parallel title. Title translated into another language.

\code{ddi_subTitl()} is the subtitle. A secondary title used to amplify or state certain limitations
on the main title. It may repeat information already in the main title.
}
\section{Shared and complex child nodes}{

\itemize{
\item \code{\link[=ddi_titl]{ddi_titl()}}
}
}

\examples{
ddi_titlStmt()

# Functions that need to be wrapped in ddi_titlStmt()

ddi_altTitl("Alternative Title of work")

ddi_IDNo(agency = "agency name", "ID number")

ddi_parTitl(lang = "fr", "French translation of the title")

ddi_subTitl("Subtitle of work")

}
\references{
\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/titlStmt.html}{titlStmt documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/altTitl.html}{altTitl documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/IDNo.html}{IDNo documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/parTitl.html}{parTitl documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/subTitl.html}{subTitl documentation}
}
